/*
 * Decompiled with CFR 0.152.
 */
package org.openxri;

import org.openxri.ParseStream;
import org.openxri.XRIParseException;

public abstract class Parsable {
    String msValue = null;
    boolean mbParsed = false;
    boolean mbParseResult = false;

    Parsable() {
        this.setValue(null);
    }

    Parsable(String sValue) {
        this.setValue(sValue);
    }

    private void setValue(String sValue) {
        this.msValue = sValue;
    }

    public String toString() {
        return this.msValue;
    }

    void parse() {
        String sValue = this.msValue;
        if (!this.mbParsed) {
            ParseStream oStream = new ParseStream(this.msValue);
            if (this.scan(oStream)) {
                this.mbParseResult = oStream.getData().length() == 0;
            }
            this.mbParsed = true;
        }
        if (!this.mbParseResult) {
            throw new XRIParseException("Not a valid " + this.getClass().getName() + " class: \"" + sValue + "\"");
        }
    }

    boolean scan(ParseStream oParseStream) {
        if (oParseStream == null) {
            return false;
        }
        ParseStream oStream = oParseStream.begin();
        if (this.doScan(oStream)) {
            this.setParsedValue(oParseStream.getConsumed(oStream));
            oParseStream.end(oStream);
            return true;
        }
        return false;
    }

    abstract boolean doScan(ParseStream var1);

    void setParsedValue(String sValue) {
        this.msValue = sValue != null ? sValue : "";
        this.mbParsed = true;
        this.mbParseResult = true;
    }
}

