package de.ix.developer.view;

import de.ix.developer.HelloBean;
import java.io.Serializable;
import javax.ejb.EJB;
import javax.enterprise.context.SessionScoped;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Named;

@Named
@SessionScoped
public class UserController implements Serializable {

    @EJB
    HelloBean hb;
    private static final long serialVersionUID = 1L;
    private static final String FAILURE_MESSAGE =
            "Falscher Username!";
    private String name;
    private boolean loggedIn = false;

    public String login() {
        if ("Developer".equals(name)) {
            loggedIn = true;
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(hb.greet(name)));
            return "home.xhtml";
        }

        FacesContext.getCurrentInstance().addMessage(null,
                new FacesMessage(FacesMessage.SEVERITY_WARN,
                FAILURE_MESSAGE, FAILURE_MESSAGE));
        return null;
    }

    public boolean isLoggedIn() {
        return loggedIn;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }
}
