#include "qvariant2variant.h"

#include <QRect>
#include <QPoint>

#include <cassert>
#include <cstdlib>
#include <iostream>

typedef boost::variant<int,QPoint,QRect> Variant;

int main() {

    const QVariant v1( 12 );
    const QVariant v2( QPoint( 1, 2 ) );
    const QVariant v3( QRect( 1, 2, 3, 4 ) );
    const QVariant v4( 1.2 );

    try {

        const Variant qv1 = qvariant2variant<Variant>( v1 );
        const Variant qv2 = qvariant2variant<Variant>( v2 );
        const Variant qv3 = qvariant2variant<Variant>( v3 );

        assert( boost::get<int>( qv1 ) == 12 );
        assert( boost::get<QPoint>( qv2 ) == QPoint( 1, 2 ) );
        assert( boost::get<QRect>( qv3 ) == QRect( 1, 2, 3, 4 ) );

        try {
            const Variant qv4 = qvariant2variant<Variant>( v4 );
            std::cerr << "Didn't catch exception - shouldn't happen" << std::endl;
            return EXIT_FAILURE;
        } catch ( const bad_cast & e ) {
            // ok
        } catch ( ... ) {
            throw;
        }

    } catch ( ... ) {
        std::cerr << "Caught exception - shouldn't happen" << std::endl;
        return EXIT_FAILURE;
    }

    std::cerr << "OK" << std::endl;
    return EXIT_SUCCESS;
}
