#ifndef VARIANT2QVARIANT_H__
#define VARIANT2QVARIANT_H__

#include <QVariant>
#include <QString>

#include <boost/variant.hpp>

#include <string>

struct variant2qvariant_visitor
  : boost::static_visitor<QVariant> {
    // one size fits all:
    template <typename T>
    QVariant operator()( const T & t ) const {
       return qVariantFromValue( t );
    }
};

struct variant2qvariant_visitor_with_string_conversion
  : boost::static_visitor<QVariant> {
    // special case: std::string -> QString -> QVariant
    QVariant operator()( const std::string & str ) const {
        return QString::fromStdString( str );
    }
    // general case:
    template <typename T>
    QVariant operator()( const T & t ) const {
       return qVariantFromValue( t );
    }
};

template <typename T_Variant>
QVariant variant2qvariant( const T_Variant & v ) {
    return boost::apply_visitor( variant2qvariant_visitor_with_string_conversion(), v );
}

#endif /* VARIANT2QVARIANT_H__ */
