﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using WWWings_GO;

namespace WWWings_DZS
{
 /// <summary>
 /// Datenmanager für Flüge
 /// </summary>
 public class FlugDataManager : IDisposable
 {

  // Eine Instanz des Datenkontextes pro Manager-Instanz
  WWWingsModellContainer modell = new WWWingsModellContainer();

  public FlugDataManager(bool LazyLoading = false)
  {
   modell.ContextOptions.LazyLoadingEnabled = LazyLoading;
  }

  public void Dispose()
  {
   modell.Dispose();
  }

  /// <summary>
  /// Laden eines Flugs
  /// </summary>
  public Flug GetFlug(int FlugID)
  {
   var abfrage = from flug in modell.FlugSet where flug.ID == FlugID select flug;
   return abfrage.SingleOrDefault();
  }

  /// <summary>
  /// Laden einer Liste von Flügen
  /// </summary>
  public List<Flug> GetFluege(string Abflugort, string Zielort)
  {
   var abfrage = from flug in modell.FlugSet where flug.Abflugort == Abflugort && flug.Zielort == Zielort select flug;
   return abfrage.ToList();
  }


  /// <summary>
  /// Reduzieren der Platzanzahl
  /// </summary>
  public bool ReducePlatzAnzahl(int FlugID, short Platzanzahl)
  {
   var einzelnerFlug = GetFlug(FlugID);

   if (einzelnerFlug != null)
   {
    if (einzelnerFlug.FreiePlaetze >= Platzanzahl && einzelnerFlug.FreiePlaetze - Platzanzahl <= einzelnerFlug.Plaetze)
    {
     // Änderung durchführen
     einzelnerFlug.FreiePlaetze -= Platzanzahl;

     // Speichern
     modell.SaveChanges();
     return true;
    }
    else
    {
     return false;
    }
   }
   else
   {
    return false;
   }
  }

  public List<string> GetFlughäfen()
  {
    return modell.FlugSet.Select(f => f.Abflugort).Distinct().OrderBy(z => z).ToList();
  }
 }
}
