﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Windows.Data;
using System.Collections.Generic;

namespace WWWings_GUI_SL5.Utilities
{
  public class IndexSelectConverter : IValueConverter
  {
    private List<object> values = new List<object>();

    public List<object> Values
    {
      get { return values; }
    }

    private object defaultValue;

    public object DefaultValue
    {
      get { return defaultValue; }
      set { defaultValue = value; }
    }

    public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
    {
      if (value == null)
        return values[0];
      int index = (int)value;
      if (values.Count > index)
        return values[index];
      return defaultValue;
    }

    public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
    {
      throw new NotImplementedException();
    }
  }
}
