﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using WWWings_GUI_SL5.ModelExtensions;
using System.Collections.Generic;
using System.Windows.Media.Imaging;
using System.IO;
using WWWings_GUI_SL5.Utilities;
using WWWings_GUI_SL5.WWWingsBuchungsserviceProxy;
using System.Collections.ObjectModel;

namespace WWWings_GUI_SL5.ViewModels
{
  public class FlugauswahlViewModel : ViewModelBase
  {
    private List<Flughafen> flughäfen;

    public List<Flughafen> Flughäfen
    {
      get { return flughäfen; }
      set { flughäfen = value; OnPropertyChanged("Flughäfen"); }
    }

    private Flughafen abflugort;

    public Flughafen Abflugort
    {
      get { return abflugort; }
      set { abflugort = value; OnPropertyChanged("Abflugort"); StartUndZielPrüfen(); }
    }

    private Flughafen zielort;

    public Flughafen Zielort
    {
      get { return zielort; }
      set { zielort = value; OnPropertyChanged("Zielort"); StartUndZielPrüfen(); }
    }

    private Flug ausgewählterFlug;

    public Flug AusgewählterFlug
    {
      get { return ausgewählterFlug; }
      set
      {
        ausgewählterFlug = value; OnPropertyChanged("AusgewählterFlug");
        IsValid = ausgewählterFlug != null;
      }
    }

    private ObservableCollection<Flug> verfügbareFlüge;

    public ObservableCollection<Flug> VerfügbareFlüge
    {
      get { return verfügbareFlüge; }
      set { verfügbareFlüge = value; OnPropertyChanged("VerfügbareFlüge"); }
    }

    public ActionCommand FlügeSuchenCommand { get; set; }

    public FlugauswahlViewModel()
    {
      wwwingsBuchungsserviceProxy.GetFluegeCompleted += 
        wwwingsBuchungsserviceProxy_GetFluegeCompleted;
      wwwingsBuchungsserviceProxy.GetFlughäfenCompleted += 
        wwwingsBuchungsserviceProxy_GetFlughäfenCompleted;
      wwwingsBuchungsserviceProxy.GetPictureCompleted += 
        wwwingsBuchungsserviceProxy_GetPictureCompleted;

      wwwingsBuchungsserviceProxy.GetFlughäfenAsync();
      FlügeSuchenCommand = new ActionCommand(FlügeSuchen);
    }

    void wwwingsBuchungsserviceProxy_GetPictureCompleted(object sender, WWWingsBuchungsserviceProxy.GetPictureCompletedEventArgs e)
    {
      Flughafen fh = e.UserState as Flughafen;
      BitmapImage bi = new BitmapImage();
      MemoryStream ms = new MemoryStream(e.Result);
      bi.SetSource(ms);
      fh.Bild = bi;
      ms.Dispose();
    }

    void wwwingsBuchungsserviceProxy_GetFlughäfenCompleted(object sender, WWWingsBuchungsserviceProxy.GetFlughäfenCompletedEventArgs e)
    {
      List<Flughafen> flughäfen = new List<Flughafen>();

      foreach (string flughafenname in e.Result)
      {
        Flughafen fh = new Flughafen();
        fh.Name = flughafenname;
        flughäfen.Add(fh);
        wwwingsBuchungsserviceProxy.GetPictureAsync(flughafenname, fh);
      }
      Flughäfen = flughäfen;
    }

    void wwwingsBuchungsserviceProxy_GetFluegeCompleted(object sender, WWWingsBuchungsserviceProxy.GetFluegeCompletedEventArgs e)
    {
      VerfügbareFlüge = e.Result;
    }

    private void FlügeSuchen()
    {
      wwwingsBuchungsserviceProxy.GetFluegeAsync(abflugort.Name, zielort.Name);
    }

    private void StartUndZielPrüfen()
    {
      FlügeSuchenCommand.IsEnabled = abflugort != null 
                                  && zielort != null 
                                  && abflugort != zielort;
    }

  }
}
