/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.webservices;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.chemistry.opencmis.client.bindings.spi.Session;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractWebServicesService;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.PortProvider;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.Converter;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectInFolderContainerType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectInFolderListType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectListType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectParentsType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumIncludeRelationships;
import org.apache.chemistry.opencmis.commons.impl.jaxb.NavigationServicePort;
import org.apache.chemistry.opencmis.commons.spi.NavigationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationServiceImpl
extends AbstractWebServicesService
implements NavigationService {
    private final PortProvider fPortProvider;

    public NavigationServiceImpl(Session session, PortProvider portProvider) {
        this.setSession(session);
        this.fPortProvider = portProvider;
    }

    public ObjectInFolderList getChildren(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        NavigationServicePort port = this.fPortProvider.getNavigationServicePort();
        try {
            return Converter.convert((CmisObjectInFolderListType)port.getChildren(repositoryId, folderId, filter, orderBy, includeAllowableActions, (EnumIncludeRelationships)Converter.convert(EnumIncludeRelationships.class, (Enum)includeRelationships), renditionFilter, includePathSegment, maxItems, skipCount, Converter.convert((ExtensionsData)extension)));
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
    }

    public List<ObjectInFolderContainer> getDescendants(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        NavigationServicePort port = this.fPortProvider.getNavigationServicePort();
        try {
            List containerList = port.getDescendants(repositoryId, folderId, depth, filter, includeAllowableActions, (EnumIncludeRelationships)Converter.convert(EnumIncludeRelationships.class, (Enum)includeRelationships), renditionFilter, includePathSegment, Converter.convert((ExtensionsData)extension));
            if (containerList == null) {
                return null;
            }
            ArrayList<ObjectInFolderContainer> result = new ArrayList<ObjectInFolderContainer>();
            for (CmisObjectInFolderContainerType container : containerList) {
                result.add(Converter.convert((CmisObjectInFolderContainerType)container));
            }
            return result;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
    }

    public ObjectData getFolderParent(String repositoryId, String folderId, String filter, ExtensionsData extension) {
        NavigationServicePort port = this.fPortProvider.getNavigationServicePort();
        try {
            return Converter.convert((CmisObjectType)port.getFolderParent(repositoryId, folderId, filter, Converter.convert((ExtensionsData)extension)));
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
    }

    public List<ObjectInFolderContainer> getFolderTree(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        NavigationServicePort port = this.fPortProvider.getNavigationServicePort();
        try {
            List containerList = port.getFolderTree(repositoryId, folderId, depth, filter, includeAllowableActions, (EnumIncludeRelationships)Converter.convert(EnumIncludeRelationships.class, (Enum)includeRelationships), renditionFilter, includePathSegment, Converter.convert((ExtensionsData)extension));
            if (containerList == null) {
                return null;
            }
            ArrayList<ObjectInFolderContainer> result = new ArrayList<ObjectInFolderContainer>();
            for (CmisObjectInFolderContainerType container : containerList) {
                result.add(Converter.convert((CmisObjectInFolderContainerType)container));
            }
            return result;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
    }

    public List<ObjectParentData> getObjectParents(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includeRelativePathSegment, ExtensionsData extension) {
        NavigationServicePort port = this.fPortProvider.getNavigationServicePort();
        try {
            List parentsList = port.getObjectParents(repositoryId, objectId, filter, includeAllowableActions, (EnumIncludeRelationships)Converter.convert(EnumIncludeRelationships.class, (Enum)includeRelationships), renditionFilter, includeRelativePathSegment, Converter.convert((ExtensionsData)extension));
            if (parentsList == null) {
                return null;
            }
            ArrayList<ObjectParentData> result = new ArrayList<ObjectParentData>();
            for (CmisObjectParentsType parent : parentsList) {
                result.add(Converter.convert((CmisObjectParentsType)parent));
            }
            return result;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
    }

    public ObjectList getCheckedOutDocs(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        NavigationServicePort port = this.fPortProvider.getNavigationServicePort();
        try {
            return Converter.convert((CmisObjectListType)port.getCheckedOutDocs(repositoryId, folderId, filter, orderBy, includeAllowableActions, (EnumIncludeRelationships)Converter.convert(EnumIncludeRelationships.class, (Enum)includeRelationships), renditionFilter, maxItems, skipCount, Converter.convert((ExtensionsData)extension)));
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
    }
}

