package de.accso.java8samples.beispiel3.stream_fehlerbehandlung;

import junit.framework.TestCase;
import java.util.Arrays;
import java.util.stream.Stream;

public class Beispiel3_Fehlerbehandlung extends TestCase {
    public static void testFall1() {
        String[] test = { "abc", "defgh", "ijk" };
        // Stream wird aufgebaut
        Stream<Character> s = Arrays.stream(test).
             map(t -> {
                  // gezielte Exception fuer alle Strings mit Laenge > 3
                  if (t.length()>3) throw new RuntimeException("error");
                  return t.charAt(0);
             });
        // Stream wird konsumiert
        s.forEach( c -> System.out.print(c.charValue() + ",") );
    }

    public static void testFall2() {
        String[] test = { "abc", "defgh", "ijk" };
        // Stream wird aufgebaut
        Stream<Character> s = Arrays.stream(test).
            map(t -> {
                       // gezielte Exception fuer alle Strings mit Laenge > 3
                       try {
                           if (t.length()>3) throw new RuntimeException("error");
                       } catch (Exception ex) { return null; }
                           return t.charAt(0);
                       });
        // Stream wird konsumiert
        s.forEach( c ->
        { if (c!=null) System.out.print(c.charValue() + ","); } );
    }

    public static void testFall3() {
         String[] test = { "abc", "defgh", "ijk" };
         // Stream wird aufgebaut
         Stream<Character> s = Arrays.stream(test).
             map(t -> {
                      // gezielte Exception fuer alle Strings mit Laenge > 3
                      if (t.length()>3) throw new RuntimeException("error");
                      return t.charAt(0);
                 });
        // Stream wird konsumiert
        s.forEach( c ->
        { try {
            System.out.print(c.charValue() + ",");
        } catch (Exception e) { e.printStackTrace(System.err); }} );
    }

    public static void main(String[] args) {
        Beispiel3_Fehlerbehandlung.testFall1(); // a wird geschrieben, dann RuntimeException
        //de.accso.java8samples.beispiel3.stream_fehlerbehandlung.Beispiel3_Fehlerbehandlung.testFall2(); // a,i wird geschrieben
        //de.accso.java8samples.beispiel3.stream_fehlerbehandlung.Beispiel3_Fehlerbehandlung.testFall3(); // a wird geschrieben, dann RuntimeException
    }
}
