package de.accso.java8samples.beispiel5.parallelisierung.a_sequentiell_und_parallel;

import junit.framework.TestCase;
import java.util.Arrays;
import java.util.stream.IntStream;

public class Beispiel5a_parallel extends TestCase {
    public static int test() {
        String[] txt = { "State", "of", "the", "Lambda", "Libraries", "Edition" };
        // Stream wird definiert
        IntStream is = Arrays.stream(txt)
                .parallel()                   // Parallelisierung!
                .filter(s -> s.length() > 3)
                .mapToInt(s -> s.length());
        // Stream wird verbraucht durch terminale Operation
        int sum = is.reduce(0, (l1, l2) -> { return (l1 + l2); });
        return sum;
    }

    public static void main(String[] args) {
        int x = Beispiel5a_parallel.test();
        System.out.println(x); // ergibt 27
    }
}
