/*
 * Project: aesdroid - AES implementation for Android
 * File   : AesTestHeler.java
 * Author : Oliver Mueller <oliver@cogito-ergo-sum.org>
 * Purpose: Helper class for Android JUnit test of class AesEncryption.
 *
 * $Id: AesTestHelper.java 44 2012-07-09 19:30:18Z oliver $
 *
 * Copyright (c) 2011, 2012 Oliver Mueller.
 * All rights reserved.
 * http://www.cogito-ergo-sum.org
 * http://oliver-mueller.com
 *
 * This software is provided 'as-is', without any express or implied warranty.
 * In no event will the author be held liable for any damages arising from
 * the use of this software.
 *
 */

package org.cogito_ergo_sum.aes;

public class AesTestHelper extends AesEncryption {

    public AesTestHelper(byte[] key) throws AesBadKeyException {
        super(key);
    }

    public void shiftRows(byte[] state, int offset) {
        super.shiftRows(state, offset);
    }
    
    public void mixColumns(byte[] state, int offset) {
        super.mixColumns(state, offset);
    }

    public void invShiftRows(byte[] state, int offset) {
        super.invShiftRows(state, offset);
    }
    
    public void invMixColumns(byte[] state, int offset) {
        super.invMixColumns(state, offset);
    }

    public void addRoundKey(byte[] state, byte[] key) {
        for(int n = 0; n < 16; n++)
            super.key[n] = key[n];
        super.addRoundKey(state, 0, 0);
    }
    
    public void encipherState(byte[] state, int offset) {
        super.encipherState(state, offset);
    }

    public void decipherState(byte[] state, int offset) {
        super.decipherState(state, offset);
    }

}
