/*
 * Project: aesdroid - AES implementation for Android
 * File   : AesReferenceTestHeler.java
 * Author : Oliver Mueller <oliver@cogito-ergo-sum.org>
 * Purpose: Helper class for Android JUnit test of class AesEncryptionReference.
 *
 * $Id: AesReferenceTestHelper.java 46 2012-07-10 06:53:42Z oliver $
 *
 * Copyright (c) 2011, 2012 Oliver Mueller.
 * All rights reserved.
 * http://www.cogito-ergo-sum.org
 * http://oliver-mueller.com
 *
 * This software is provided 'as-is', without any express or implied warranty.
 * In no event will the author be held liable for any damages arising from
 * the use of this software.
 *
 */

package org.cogito_ergo_sum.aes;

public class AesReferenceTestHelper extends AesEncryptionReference {

    public AesReferenceTestHelper(byte[] key) throws AesBadKeyException {
        super(key);
    }

    public void shiftRows(byte[] state) {
        super.shiftRows(state);
    }
    
    public void mixColumns(byte[] state) {
        super.mixColumns(state);
    }

    public void invShiftRows(byte[] state) {
        super.invShiftRows(state);
    }
    
    public void invMixColumns(byte[] state) {
        super.invMixColumns(state);
    }

    public void addRoundKey(byte[] state, byte[] key) {
        for(int n = 0; n < 16; n++)
            super.key[n] = key[n];
        super.addRoundKey(state, 0);
    }
    
    public void encipherState(byte[] state) {
        super.encipherState(state);
    }

    public void decipherState(byte[] state) {
        super.decipherState(state);
    }

}
