#include <QtCore/QObject>
#include "data.h"

Data::Data(QObject *parent) : QObject(parent) {

  image = new QImage(960, 540, QImage::Format_RGB32);
  image->fill(0x808080);
  imageIndex = 0;
}

Data::~Data() {

  delete image;
}

QImage * Data::getImage() {

  return(image);
}

QSize Data::getImageSize() {

  return(image->size());
}

void Data::setLoadFileList(QStringList list) {

  loadFileList = list;
}

void Data::loadNextImage(int delta) {
  
  if (loadFileList.count()) {
    imageIndex += delta;
    if (imageIndex < 0) imageIndex = loadFileList.count() - 1;
    else if (imageIndex > loadFileList.count() - 1) imageIndex = 0;
    image->load(loadFileList.at(imageIndex));
  }  
}

void Data::saveImage(QString fileName) {

  image->save(fileName);
}

void Data::scaleImage(double scale) {

  QImage scaledImage = image->scaled((double)image->width() *  scale, (double)image->height() * scale, Qt::IgnoreAspectRatio, Qt::SmoothTransformation);
  *image = scaledImage;
} 

void Data::rotateImage(double angle) {

  QMatrix matrix;
  matrix.rotate(angle);
  QImage rotatedImage = image->transformed(matrix, Qt::SmoothTransformation);
  *image = rotatedImage;
}
