#include <QtGui/QVBoxLayout>
#include <QtGui/QHBoxLayout>
#include <QtGui/QScrollArea>
#include <QtGui/QPalette>
#include <QtGui/QFileDialog>
#include <QtGui/QInputDialog>
#include "gui.h"

Gui::Gui(Data *p_data, QWidget *parent) : QWidget(parent) {

  data = p_data;
  QVBoxLayout *guiLayout = new QVBoxLayout;
  setLayout(guiLayout);
  view = new View(data, this);
  view->updateSize();
  QScrollArea *scroll = new QScrollArea;
  scroll->setBackgroundRole(QPalette::Dark);
  scroll->setWidget(view);
  guiLayout->addWidget(scroll);
  fullView = new View(data, this, true, Qt::Window | Qt::FramelessWindowHint);
  QObject::connect(fullView, SIGNAL(leaveFullScreen()), this, SLOT(normalScreen()));
  QHBoxLayout *buttonLayout = new QHBoxLayout;
  slideShowButton = new QPushButton("Diashow");
  QObject::connect(slideShowButton, SIGNAL(clicked()), this, SLOT(slideShow()));
  buttonLayout->addSpacing(150);
  buttonLayout->addWidget(slideShowButton);
  buttonLayout->addSpacing(200);
  fullScreenButton = new QPushButton("Vollbild");
  QObject::connect(fullScreenButton, SIGNAL(clicked()), this, SLOT(fullScreen()));
  buttonLayout->addWidget(fullScreenButton);
  buttonLayout->addSpacing(150);
  QWidget *buttonFrame = new QWidget;
  buttonFrame->setLayout(buttonLayout);
  guiLayout->addWidget(buttonFrame);
  timer = new QTimer(this);
  timer->setInterval(3000);
  QObject::connect(timer, SIGNAL(timeout()), this, SLOT(nextSlide()));
}

void Gui::loadImages(QStringList fileNames) {

  data->setLoadFileList(fileNames);
  data->loadNextImage(0);
  view->updateSize();
}

void Gui::loadImages() {

  loadImages(QFileDialog::getOpenFileNames());
}

void Gui::saveImage() {

  data->saveImage(QFileDialog::getSaveFileName());
}

void Gui::scaleImage() {
  
  bool ok;
  double scale = QInputDialog::getDouble(this, "Bild skalieren", "Skalierungsfaktor:", 0.25, 0.01, 10, 3, &ok);
  if (ok) {
    data->scaleImage(scale);
    view->updateSize();
  }  
}

void Gui::slideShow() {

  bool ok;
  double dt = QInputDialog::getDouble(this, "Anzeigedauer pro Bild", "Anzeigedauer:", 3.0, 0.01, 600, 4, &ok);
  if (ok) timer->setInterval(dt * 1000.0);
  timer->start();
  fullScreen();
}

void Gui::fullScreen() {

  fullView->showFullScreen();
  fullView->raise();
  fullView->setFocusPolicy(Qt::StrongFocus);
  fullView->setFocus();
}

void Gui::normalScreen() {

  view->updateSize();
  fullView->hide();
  timer->stop();
}

void Gui::nextSlide() {

  data->loadNextImage(1);
  fullView->updateSize();
}
