#ifndef GUI_H
#define GUI_H

#include <QtGui/QWidget>
#include <QtGui/QPushButton>
#include <QtCore/QStringList>
#include <QtCore/QTimer>
#include "data.h"
#include "view.h"

class Gui : public QWidget
{
  Q_OBJECT

  private:
    Data *data;
    View *view, *fullView;
    QPushButton *slideShowButton, *fullScreenButton;
    QTimer *timer;

  public:
    Gui(Data *p_data, QWidget* parent=0);
     
  public slots: 
    void loadImages(QStringList fileNames);
    void loadImages();
    void saveImage();
    void scaleImage();
    void slideShow();
    void fullScreen();
    void normalScreen();
    void nextSlide();
};

#endif
