#include <QtGui/QApplication>
#include <QtGui/QDesktopWidget>
#include <QtGui/QMainWindow>
#include <QtGui/QMenuBar>   
#include <QtGui/QMenu>   
#include <QtCore/QString>   
#include <QtCore/QStringList>   
#include "data.h"
#include "gui.h"

int main(int argc, char *argv[])  
{
  QApplication myApp(argc, argv);
  QMainWindow top;
  top.setWindowTitle("QSimpleViewer    (c)2011 by Matthias Nagorni");
  Data *data = new Data(&myApp);
  Gui *gui = new Gui(data, &top);
  QMenu *fileMenu = top.menuBar()->addMenu("&Datei");
  fileMenu->addAction("Bilder &Laden", gui, SLOT(loadImages()));
  fileMenu->addAction("Bild &Speichern", gui, SLOT(saveImage()));
  fileMenu->addSeparator();
  fileMenu->addAction("&Beenden", &myApp, SLOT(quit()));
  QMenu *imageMenu = top.menuBar()->addMenu("&Bild");
  imageMenu->addAction("Bild &Skalieren", gui, SLOT(scaleImage()));
  top.setCentralWidget(gui); 
  top.show();
  top.setGeometry(100, 100, data->getImageSize().width(), data->getImageSize().height());
  if (argc > 1) gui->loadImages(QStringList(argv[1]));
  return myApp.exec(); 
}
