#include <QtGui/QColor>
#include <QtGui/QPainter>
#include "data.h"
#include "view.h"

View::View(Data *p_data, QWidget *parent, bool p_fullScreenMode, Qt::WindowFlags f) : QWidget(parent, f) {

  data = p_data;
  fullScreenMode = p_fullScreenMode;
  setPalette(QColor(64, 64, 64));
}

View::~View() {
}

void View::paintEvent(QPaintEvent *) {

  QPainter p;
  
  p.begin(this);
  if (fullScreenMode) {
    QImage fullImage = (*data->getImage()).scaled(width(), height(), Qt::KeepAspectRatio, Qt::SmoothTransformation);
    p.drawImage((width() - fullImage.width()) / 2, (height() - fullImage.height()) / 2, fullImage);
  } else {
    p.drawImage(0, 0, *data->getImage());  
  }  
  p.end();
}

void View::updateSize() {

  if (!fullScreenMode) {
    setMinimumSize(data->getImageSize());
    setMaximumSize(data->getImageSize());
  }  
  repaint();
}

void View::mouseReleaseEvent (QMouseEvent *ev) {

  if (ev->button() == Qt::LeftButton) data->loadNextImage(-1);
  if (ev->button() == Qt::RightButton) data->loadNextImage(1);
  if (ev->button() == Qt::MidButton) data->rotateImage(90);
  updateSize();
}

void View::keyReleaseEvent(QKeyEvent *ev) {

  if (fullScreenMode && (ev->key() == Qt::Key_Escape)) 
    emit leaveFullScreen();
  if (ev->key() == Qt::Key_T) {
    data->rotateImage(90);  
    updateSize();
  }  
}
