#ifndef VIEW_H
#define VIEW_H

#include <QtGui/QWidget>
#include <QtGui/QMouseEvent>
#include <QtGui/QKeyEvent>
#include "data.h"

class View : public QWidget
{
  Q_OBJECT

  private:
    Data *data;
    bool fullScreenMode;

  public:
    View(Data *p_data, QWidget* parent=0, bool p_fullScreenMode = false, Qt::WindowFlags f=0);
    ~View();
    void updateSize();

  signals:
    void leaveFullScreen();

  protected:
    virtual void paintEvent(QPaintEvent *);
    virtual void mouseReleaseEvent (QMouseEvent *ev);
    virtual void keyReleaseEvent(QKeyEvent *ev);
};
  
#endif
