#include <QtGui/QMessageBox>
#include <jack/jack.h>
#include <jack/midiport.h>
#include <stdio.h>
#include "jackprocessor.h"

JackProcessor::JackProcessor(QObject *parent) : QObject(parent) {
}

JackProcessor::~JackProcessor() {

  jack_port_unregister (jackHandle, jackMidi);
  jack_client_close (jackHandle);
}

int JackProcessor::initJack() {

  if ((jackHandle = jack_client_open("QMidiViewer", JackNullOption, NULL)) == 0) {
    QMessageBox::critical(0, "QMidiViewer", "JACK server not running ?");
    exit(1);
  }
  jackMidi = jack_port_register(jackHandle, "QMidiViewer_MIDI_In", JACK_DEFAULT_MIDI_TYPE, JackPortIsInput, 0);
  jack_set_process_callback(jackHandle, jack_static_callback, (void *)this);
  if (jack_activate(jackHandle)) {
    QMessageBox::critical(0, "QMidiViewer", "Can't activate JACK.");
    exit(1);
  }  
  return(0);
}

int JackProcessor::jack_static_callback(jack_nframes_t nframes, void *arg)
{
  return ((JackProcessor *) arg)->jack_callback(nframes);
}

int JackProcessor::jack_callback(jack_nframes_t nframes)
{
  jack_midi_event_t ev;
  jack_nframes_t ev_count;
  int type, ch, index, val;

  void* midiBuf = jack_port_get_buffer(jackMidi, nframes);
  ev_count = jack_midi_get_event_count(midiBuf); 
  while (ev_count) {
    ev_count--;
    jack_midi_event_get(&ev, midiBuf, ev_count);
    type = *(ev.buffer) & 0xf0;
    ch = *(ev.buffer) & 0x0f;  
    index = *(ev.buffer + 1);  
    val = *(ev.buffer + 2);    
    emit midiEvent(type, ch, index, val);
  }   
  return 0;
}
