#include <QtGui/QVBoxLayout>
#include <QtGui/QPushButton>
#include <QtCore/QString>
#include "gui.h"

Gui::Gui(QWidget *parent) : QWidget(parent) {

  QVBoxLayout *guiLayout = new QVBoxLayout;
  setLayout(guiLayout);
  calc = new Calc(1e9);
  QObject::connect(calc, SIGNAL(finished()), this, SLOT(calcFinished()));
  label = new QLabel("Berechne kleinste Primzahl > " + 
                     QString::number(calc->startValue));
  guiLayout->addWidget(label);
  QPushButton *button = new QPushButton("Start");
  guiLayout->addWidget(button);
  QObject::connect(button, SIGNAL(clicked()), this, SLOT(doCalc()));
}

void Gui::doCalc() {

  if (!calc->isRunning()) {
    label->setText(QString::fromUtf8("Berechnung läuft..."));
    calc->start();
  }  
}

void Gui::calcFinished() {

  label->setText("Kleinste Primzahl > " + 
                 QString::number(calc->startValue) + 
                 " = " + QString::number(calc->primzahl));
}
