#ifndef DATA_H
#define DATA_H

#include <QtCore/QObject>
#include <QtCore/QString>
#include <QtCore/QSize>
#include <QtCore/QMutex>
#include <QtGui/QImage>
#include <QtGui/QColor>

const int imageWidth = 8000;
const int imageHeight = 6000;
const int chunkLen = 100;
const int maxIterations = 2000;

class Data : public QObject
{
  private:
    QImage *image;
    int chunkCount, threadCount;
    QColor palette[maxIterations+1];
    
  public:
    QMutex calcMutex, chunkMutex;  
    bool shutdownFlag;
    
  public:
    Data(QObject* parent=0);
    ~Data();
    void initPalette();
    QColor getPalette(int paletteIndex);
    QImage * getImage();
    QSize getImageSize();
    void loadImage(QString fileName);
    void saveImage(QString fileName);
    void scaleImage(double scale);
    void setThreadCount(int value);
    int getThreadCount();
    void calcChunks();
    int  getChunkCount();
    bool getNextChunk(int &start, int &len);
};
  
#endif
