#include <QtGui/QHBoxLayout>
#include <QtGui/QVBoxLayout>
#include <QtGui/QScrollArea>
#include <QtGui/QFileDialog>
#include <QtGui/QInputDialog>
#include <QtCore/QSize>
#include "gui.h"

Gui::Gui(int threadCount, QWidget *parent) : QWidget(parent) {

  int i;

  data = new Data(this);
  data->setThreadCount(threadCount); 
  QVBoxLayout *guiLayout = new QVBoxLayout;
  setLayout(guiLayout);
  QScrollArea *scroll = new QScrollArea;
  view = new View(data, this);
  view->updateSize();
  scroll->setWidget(view);
  guiLayout->addWidget(scroll);
  data->calcChunks();
  readyCounter = 0;
  timer = new QTimer(this);
  timer->setSingleShot(true);
  timer->setInterval(100);
  QObject::connect(timer, SIGNAL(timeout()), this, SLOT(updateStatus()));
  timer->start();
  time.start();
  for (i = 0; i < data->getThreadCount(); i++) {
    calc << new Calc(data, i);
    QObject::connect(calc.at(i), SIGNAL(finished()), this, SLOT(calcFinished()));
    calc.at(i)->start();
  }
  label = new QLabel("Status: Calculating");
  guiLayout->addWidget(label);
}

Gui::~Gui() {

  int i;

  data->shutdownFlag = true;
  for (i = 0; i < data->getThreadCount(); i++) {
    calc.at(i)->wait();
  }  
}

void Gui::saveImage() {

  data->saveImage(QFileDialog::getSaveFileName());
}

void Gui::scaleImage() {
  
  bool ok;
  if (readyCounter == data->getThreadCount()) {
    data->scaleImage(QInputDialog::getDouble(this, "Bild skalieren", "Skalierungsfaktor:", 0.25, 0.001, 10, 3, &ok));
    view->updateSize();
  }  
}

void Gui::calcFinished() {

  readyCounter++;
  if (readyCounter == data->getThreadCount()) {
    view->repaint();
    label->setText("Status: Ready     Time elapsed: " + QString::number(time.elapsed()) + " ms");
  }
}

void Gui::updateStatus() {

   QString status;
   
   status =  QString::number(100 - (int)(100.0 * (double)data->getChunkCount() * (double)chunkLen / (double)data->getImageSize().height()));
   if (data->getChunkCount() >= 0) {
     label->setText("Status: Computing in " + QString::number(data->getThreadCount()) + " Threads   [" + status +"%]");
     timer->start(); 
   } 
}
