#ifndef HIRESVIEW_H
#define HIRESVIEW_H

#include <math.h>
#include <QtGui/QWidget>
#include <QtGui/QMouseEvent>
#include <QtCore/QString>
#include <QtCore/QPoint>
#include "data.h"

class HiresView : public QWidget
{
  Q_OBJECT

  private:
    Data *data;
    QPoint mousePos;
    bool mousePressed;
        
  public:
    HiresView(Data *p_data, QWidget* parent=0, int w=300, int h=200);
    ~HiresView();

  protected:
    virtual void paintEvent(QPaintEvent *);
    virtual void mousePressEvent (QMouseEvent* );
    virtual void mouseReleaseEvent (QMouseEvent* );
    virtual void mouseMoveEvent (QMouseEvent* );

  signals:
    void moveView(QPoint dp);
                
  public slots: 
    void changeColor();
};
  
#endif
