#include <QtGui/QApplication>
#include <QtGui/QMainWindow>
#include <QtGui/QMenuBar>   
#include <QtGui/QMenu>   
#include <QtCore/QString>   
#include "data.h"
#include "gui.h"

int main(int argc, char *argv[])  
{
  QApplication myApp(argc, argv);
  QMainWindow top;
  top.setWindowTitle("QJulia    (c)2012 by Matthias Nagorni");
  Gui *gui = new Gui(&top);
  QMenu *fileMenu = top.menuBar()->addMenu("&File");
  fileMenu->addAction("Save &Mandelbrot Image", gui, SLOT(saveMandel()));
  fileMenu->addAction("Save &Julia Image", gui, SLOT(saveJulia()));
  fileMenu->addAction("Save &High Resolution Image", gui, SLOT(saveHiRes()));
  fileMenu->addSeparator();
  fileMenu->addAction("&Load Mandelbrot Palette", gui, SLOT(loadMandelPalette()));
  fileMenu->addAction("L&oad Julia Palette", gui, SLOT(loadJuliaPalette()));
  fileMenu->addAction("&Save Mandelbrot Palette", gui, SLOT(saveMandelPalette()));
  fileMenu->addAction("S&ave Julia Palette", gui, SLOT(saveJuliaPalette()));
  fileMenu->addSeparator();
  fileMenu->addAction("Loa&d State", gui, SLOT(loadState()));
  fileMenu->addAction("Sav&e State", gui, SLOT(saveState()));
  fileMenu->addSeparator();
  fileMenu->addAction("&Quit", &myApp, SLOT(quit()));
  QMenu *viewMenu = top.menuBar()->addMenu("&View");
  viewMenu->addAction("&High Resolution Window", gui, SLOT(showHiRes()));
  QMenu *settingsMenu = top.menuBar()->addMenu("&Settings");
  settingsMenu->addAction("&Colors", gui, SLOT(showColorDialog()));
  settingsMenu->addAction("&Options", gui, SLOT(showIterationDialog()));
  top.setCentralWidget(gui); 
  top.show();
  return myApp.exec(); 
}
