#ifndef PALETTE_H
#define PALETTE_H

#include <QtGui/QWidget>
#include <QtGui/QPainter>
#include <QtGui/QMouseEvent>
#include <QtGui/QRgb>
#include "data.h"

#define MARGIN 10

class Palette : public QWidget
{
  Q_OBJECT

  private:
    int index, curIndex;
    Data *data;
    QPoint mousePos;
    bool mousePressed;

  public:
    Palette(int p_index, Data *p_data, QWidget* parent=0, Qt::WindowFlags f=0);
    ~Palette();

  protected:
    virtual void paintEvent(QPaintEvent *);
    virtual void mousePressEvent (QMouseEvent* );
    virtual void mouseReleaseEvent (QMouseEvent* );
    virtual void mouseMoveEvent (QMouseEvent* );

  signals:
    void paletteChanged();

  public slots: 
    void editColor();
    void deleteColor();
};

#endif
