/*
 * Decompiled with CFR 0.152.
 */
package net.nieden.FileCrypter;

import java.awt.Font;
import java.awt.GridLayout;
import java.io.File;
import java.io.RandomAccessFile;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class CFileCrypterHexdump
extends JFrame {
    static final int MAX_ROWS = 64;
    static final int COLUMNS = 32;
    private static final long serialVersionUID = 2L;
    JTextArea jtaHexdump = new JTextArea();
    JScrollPane jspHexdump = new JScrollPane(this.jtaHexdump, 22, 31);
    File f;
    RandomAccessFile raf;

    public CFileCrypterHexdump(String string) throws Exception {
        this.f = new File(string);
        if (!this.f.isFile()) {
            throw new Exception(string + " is NOT a regular file!");
        }
        this.raf = new RandomAccessFile(this.f, "r");
        this.buildGUI();
        this.hexDump(0L);
    }

    public void buildGUI() throws Exception {
        this.setDefaultCloseOperation(2);
        this.setLayout(new GridLayout(1, 1));
        this.jtaHexdump.setFont(new Font("Courier", 1, 12));
        this.getContentPane().add(this.jspHexdump);
        this.setSize(1024, 768);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.jtaHexdump.setEditable(false);
        this.setVisible(true);
    }

    public void hexDump(long l) throws Exception {
        if (l >= this.f.length()) {
            return;
        }
        long l2 = this.f.length() - l;
        long l3 = l2 / 32L;
        int n = (int)l2 % 32;
        if (n > 0) {
            ++l3;
        }
        byte[] byArray = new byte[(int)this.f.length()];
        this.raf.seek(l);
        this.raf.read(byArray, 0, (int)this.f.length());
        System.out.printf("%d byte(s) read.\n", this.f.length());
        System.out.flush();
        System.out.printf("%d lines to process ... buffer.length=%d\n", l3, byArray.length);
        StringBuffer stringBuffer = new StringBuffer((int)(this.f.length() + l3));
        int n2 = 0;
        while ((long)n2 < l3) {
            boolean bl;
            int n3;
            stringBuffer.append(String.format("%08x: ", l + (long)(n2 * 32)));
            for (n3 = 0; n3 < 32; ++n3) {
                boolean bl2 = bl = (long)(n2 + 1) == l3 && n > 0;
                if (bl) {
                    stringBuffer.append("   ");
                } else {
                    stringBuffer.append(String.format("%02x ", byArray[n2 * 32 + n3] & 0xFF));
                }
                if (n3 + 1 != 16) continue;
                stringBuffer.append("- ");
            }
            for (n3 = 0; n3 < 32; ++n3) {
                boolean bl3 = bl = (long)(n2 + 1) == l3 && n > 0;
                if (bl) break;
                int n4 = byArray[n2 * 32 + n3] & 0xFF;
                boolean bl4 = n4 >= 32 && n4 < 192;
                stringBuffer.append(String.format("%c", bl4 ? n4 : 46));
            }
            stringBuffer.append("\n");
            ++n2;
        }
        System.out.println("Setting TEXT ...");
        System.out.flush();
        this.jtaHexdump.setText(stringBuffer.toString());
        this.jtaHexdump.updateUI();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            return;
        }
        try {
            for (String string : stringArray) {
                new CFileCrypterHexdump(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

