/*
 * Decompiled with CFR 0.152.
 */
package net.nieden.FileCrypter;

import java.awt.Dialog;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.File;
import java.io.RandomAccessFile;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import net.nieden.FileCrypter.CFileTools;

public class CFileHexDump
extends JFrame
implements ActionListener,
AdjustmentListener {
    private static final long serialVersionUID = 3L;
    RandomAccessFile raf;
    JScrollPane jspOffset;
    JScrollPane jspHexDump;
    JScrollPane jspText;
    long lOffset = 0L;
    long lFileSize;
    JTable jtOffset = new JTable();
    JTable jtHexdump = new JTable();
    JTable jtText = new JTable();
    JScrollBar jsb = new JScrollBar();

    public CFileHexDump(File file) throws Exception {
        super("Hexdump of \"" + file.getName() + "\"");
        this.lFileSize = file.length();
        this.raf = new RandomAccessFile(file, "r");
        this.buildGUI();
        this.displayBuffer();
    }

    public void buildGUI() throws Exception {
        Font font = new Font("Courier", 1, 17);
        this.jspOffset = new JScrollPane(this.jtOffset, 21, 31);
        this.jspHexDump = new JScrollPane(this.jtHexdump, 21, 31);
        this.jspText = new JScrollPane(this.jtText, 21, 31);
        this.setLayout(null);
        this.setSize(800, 600);
        this.setDefaultCloseOperation(2);
        this.jspOffset.setBounds(10, 10, 100, 532);
        this.jspHexDump.setBounds(120, 10, 468, 532);
        this.jspText.setBounds(595, 10, 172, 532);
        this.jsb.setBounds(770, 10, 18, 532);
        this.getContentPane().add(this.jspOffset);
        this.getContentPane().add(this.jspHexDump);
        this.getContentPane().add(this.jspText);
        this.getContentPane().add(this.jsb);
        CFileTools.initTable(this.jtOffset, new String[]{"100;S;Offset"}, 32, false, font);
        CFileTools.initTable(this.jtText, new String[]{"170;S;ASCII"}, 32, false, font);
        String[] stringArray = new String[17];
        for (int i = 0; i < 17; ++i) {
            stringArray[i] = i != 8 ? String.format("28;I;%02x", i < 8 ? i : i - 1) : "32;S; - ";
        }
        CFileTools.initTable(this.jtHexdump, stringArray, 32, false, font);
        this.setLocationRelativeTo(null);
        CFileTools.setIconImageFromResource(this, "geany.png");
        this.setResizable(false);
        this.setVisible(true);
        this.jspText.getVerticalScrollBar().setMaximum(2);
        this.jsb.addAdjustmentListener(this);
        this.jsb.setMaximum((int)this.lFileSize / 16);
        this.setModalExclusionType(Dialog.ModalExclusionType.TOOLKIT_EXCLUDE);
    }

    public void displayBuffer() throws Exception {
        byte[] byArray = new byte[512];
        this.raf.seek(this.lOffset);
        int n = this.raf.read(byArray, 0, byArray.length);
        int n2 = n / 16;
        int n3 = n % 16;
        if (n3 > 0) {
            ++n2;
        }
        for (int i = 0; i < 32; ++i) {
            if (i >= n2) {
                this.jtOffset.setValueAt("", i, 0);
                for (int j = 0; j < 17; ++j) {
                    this.jtHexdump.setValueAt("", i, j);
                }
                this.jtText.setValueAt("", i, 0);
                continue;
            }
            String string = String.format("%09x", this.lOffset + (long)(16 * i));
            this.jtOffset.setValueAt(string, i, 0);
            int n4 = i + 1 == n2 && n3 > 0 ? n3 : 16;
            this.jtHexdump.setValueAt(" -", i, 8);
            String string2 = "";
            for (int j = 0; j < 16; ++j) {
                int n5 = byArray[i * 16 + j] & 0xFF;
                string = j < n4 ? String.format("%02x", n5) : "";
                this.jtHexdump.setValueAt(string, i, j < 8 ? j : j + 1);
                string2 = string2 + (n5 < 32 ? "." : String.format("%c", n5));
            }
            this.jtText.setValueAt(string2, i, 0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        int n = adjustmentEvent.getValue();
        this.lOffset = 16 * n;
        try {
            this.displayBuffer();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            for (String string : stringArray) {
                File file = new File(string);
                if (!file.isFile()) continue;
                try {
                    new CFileHexDump(file);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

