/*
 * Decompiled with CFR 0.152.
 */
package net.nieden.FileCrypter;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import net.nieden.FileCrypter.CDirChooser;
import net.nieden.FileCrypter.CFileEncrypter;
import net.nieden.FileCrypter.CFileHexDump;
import net.nieden.FileCrypter.CFileTools;
import net.nieden.FileCrypter.IFileProcessInterrupter;
import net.nieden.FileCrypter.IFileProgressIndicator;

public class CFileCrypterGUI
extends JFrame
implements ActionListener,
MouseListener,
IFileProgressIndicator {
    private static final long serialVersionUID = 1L;
    JButton jbCancel = new JButton("Cancel");
    JButton jbStart = new JButton("Start");
    JButton jbAddFile = new JButton("Add file(s)");
    JButton jbExit = new JButton("Exit");
    JTable jtFileTable = new JTable();
    JScrollPane jspFileTable = new JScrollPane(this.jtFileTable, 22, 30);
    JLabel jlGroupBox1 = new JLabel("");
    JLabel jlGroupBox2 = new JLabel("");
    JLabel jlGroupBox3 = new JLabel("");
    JLabel jlGroupBox4 = new JLabel("");
    JLabel jlPasswd = new JLabel("Password");
    JLabel jlBufSize = new JLabel("BufSize in");
    JPasswordField jtfPasswd = new JPasswordField();
    JRadioButton jrbComp1 = new JRadioButton("None", true);
    JRadioButton jrbComp2 = new JRadioButton("GZIP", false);
    JRadioButton jrbComp3 = new JRadioButton("7-Zip", false);
    JRadioButton jrbBufKB = new JRadioButton("KB", true);
    JRadioButton jrbBufMB = new JRadioButton("MB", false);
    JCheckBox jcbMultiThread = new JCheckBox("enable MT", true);
    JLabel jlImage = new JLabel(new ImageIcon("Images/safe_into.png"));
    private JPopupMenu jm = new JPopupMenu();
    ButtonGroup bg1 = new ButtonGroup();
    ButtonGroup bg2 = new ButtonGroup();
    SpinnerModel model = new SpinnerNumberModel(256, 16, 32768, 16);
    JSpinner jspBufSize = new JSpinner(this.model);
    JProgressBar jpb;
    IFileProcessInterrupter fileProcessInterrupter = null;
    Boolean oldStateKBSelected = true;
    Boolean oldStateMBSelected = false;
    Boolean canceled = false;
    Object[] ctrlList = new Object[]{this.jlGroupBox1, 2, 22, 178, 86, this.jlGroupBox2, 2, 114, 595, 368, this.jlGroupBox3, 180, 22, 110, 86, this.jlGroupBox4, 290, 22, 150, 86, this.jlImage, 588, 2, 128, 128, this.jbStart, 600, 134, 100, 19, this.jbCancel, 600, 154, 100, 19, this.jbAddFile, 600, 174, 100, 19, this.jbExit, 600, 194, 100, 19, this.jspFileTable, 10, 134, 580, 342, this.jlPasswd, 10, 50, 100, 24, this.jcbMultiThread, 86, 48, 90, 22, this.jtfPasswd, 10, 72, 160, 24, this.jlBufSize, 300, 50, 80, 24, this.jspBufSize, 300, 72, 80, 24, this.jrbComp1, 188, 46, 90, 16, this.jrbComp2, 188, 62, 90, 16, this.jrbComp3, 188, 78, 90, 16, this.jrbBufKB, 380, 62, 50, 16, this.jrbBufMB, 380, 78, 50, 16, null};

    public CFileCrypterGUI() throws Exception {
        this.buildGUI();
    }

    public void buildGUI() throws Exception {
        int n;
        int n2;
        String[] stringArray = new String[]{"40;I;Nr.;0", "320;S;Filename;0", "50;B;Marked;1", "60;B;Processed;0", "100;I;Filesize;0"};
        this.setLayout(null);
        CFileTools.initTable(this.jtFileTable, stringArray, 80, true);
        for (n2 = 0; n2 < 80; ++n2) {
            this.jtFileTable.setValueAt(n2 + 1, n2, 0);
        }
        n2 = 0;
        while (this.ctrlList[n2] != null) {
            this.getContentPane().add((JComponent)this.ctrlList[n2]);
            ((JComponent)this.ctrlList[n2]).setBounds((Integer)this.ctrlList[n2 + 1], (Integer)this.ctrlList[n2 + 2], (Integer)this.ctrlList[n2 + 3], (Integer)this.ctrlList[n2 + 4]);
            if ((JComponent)this.ctrlList[n2] == this.jlGroupBox1) {
                this.jlGroupBox1.setBorder(BorderFactory.createTitledBorder("Security settings"));
            } else if ((JComponent)this.ctrlList[n2] == this.jlGroupBox2) {
                this.jlGroupBox2.setBorder(BorderFactory.createTitledBorder("Select file(s) for encryption"));
            } else if ((JComponent)this.ctrlList[n2] == this.jlGroupBox3) {
                this.jlGroupBox3.setBorder(BorderFactory.createTitledBorder("Compression"));
            } else if ((JComponent)this.ctrlList[n2] == this.jlGroupBox4) {
                this.jlGroupBox4.setBorder(BorderFactory.createTitledBorder("Buffer Size"));
            } else if ((JComponent)this.ctrlList[n2] instanceof JButton) {
                ((JButton)this.ctrlList[n2]).setRolloverEnabled(true);
                ((JButton)this.ctrlList[n2]).addActionListener(this);
            } else if ((JComponent)this.ctrlList[n2] instanceof JRadioButton) {
                if (Arrays.asList(this.jrbComp1, this.jrbComp2, this.jrbComp3).contains(this.ctrlList[n2])) {
                    this.bg1.add((JRadioButton)this.ctrlList[n2]);
                } else {
                    this.bg2.add((JRadioButton)this.ctrlList[n2]);
                    ((JRadioButton)this.ctrlList[n2]).addActionListener(this);
                }
            }
            ((JComponent)this.ctrlList[n2]).setVisible(true);
            n2 += 5;
        }
        String[] stringArray2 = new String[]{"Add directory to list", "Add file(s) to list", "Remove selected item from list", "Remove marked item(s) from list", "", "Mark all items", "Unmark all items", "Invert mark state", "Hexdump of currently selected file", "", "Start encryption", "", "Exit program"};
        for (n = 0; n < stringArray2.length; ++n) {
            if (!stringArray2[n].isEmpty()) {
                JMenuItem jMenuItem = this.jm.add(stringArray2[n]);
                jMenuItem.addActionListener(this);
                continue;
            }
            this.jm.addSeparator();
        }
        this.jtFileTable.addMouseListener(this);
        this.jtFileTable.getSelectionModel().setSelectionMode(0);
        this.jbCancel.setEnabled(false);
        this.setResizable(false);
        this.setSize(720, 550);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        CFileTools.setIconImageFromResource(this, "safe_into.png");
        this.setTitle(CFileCrypterGUI.class.getSimpleName());
        this.jtFileTable.updateUI();
        n = 0;
        while (this.ctrlList[n] != null) {
            ((JComponent)this.ctrlList[n]).updateUI();
            n += 5;
        }
        ((JSpinner.DefaultEditor)this.jspBufSize.getEditor()).getTextField().setEnabled(false);
        JMenuBar jMenuBar = this.initMainMenu(new String[]{"File;Add directory to list;Add files to List;-;Preferences;-;Exit", "Edit;Undo;-;Mark selected;Unmark Selected", "Tools;Show Hexdump of current selected file", "Help;About"});
        this.setJMenuBar(jMenuBar);
        jMenuBar.updateUI();
    }

    private void addFileToTable(File file) {
        if (this.fileExistsInTable(file, true)) {
            return;
        }
        int n = this.getLastEntryRowIndex();
        this.jtFileTable.setValueAt(file.getAbsolutePath(), n, 1);
        this.jtFileTable.setValueAt(true, n, 2);
        this.jtFileTable.setValueAt(CFileTools.printDottedNumber(file.length()), n, 4);
    }

    private boolean fileExistsInTable(File file, boolean bl) {
        int n = this.jtFileTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            String string = (String)this.jtFileTable.getValueAt(i, 1);
            if (string == null || string.isEmpty()) {
                return false;
            }
            if (!string.equals(file.getAbsolutePath())) continue;
            if (bl) {
                JOptionPane.showMessageDialog(null, "Skipping file \"" + file.getAbsolutePath() + "\" - already exists in table!", "Skipping file", 2);
            }
            return true;
        }
        return false;
    }

    private void addFilesToList() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setMultiSelectionEnabled(true);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setCurrentDirectory(new File("."));
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File[] fileArray;
            for (File file : fileArray = jFileChooser.getSelectedFiles()) {
                if (!file.isFile() || file.length() <= 0L) continue;
                this.addFileToTable(file);
            }
        }
    }

    private void addDirectoryToList() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    CDirChooser cDirChooser = new CDirChooser(new File(System.getProperty("user.dir")));
                    if (cDirChooser.isPathSelected()) {
                        File file = new File(cDirChooser.getPathSelected());
                        for (File file2 : file.listFiles()) {
                            if (!file2.isFile() || file2.length() <= 0L) continue;
                            CFileCrypterGUI.this.addFileToTable(file2);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }).start();
    }

    private void reorganizeTableIndex() {
        int n = this.jtFileTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.jtFileTable.setValueAt(i + 1, i, 0);
        }
    }

    private int getMarkedColumnCount() {
        String string;
        int n = this.jtFileTable.getRowCount();
        if (n == 0) {
            return 0;
        }
        int n2 = 0;
        for (int i = 0; i < n && (string = (String)this.jtFileTable.getValueAt(i, 1)) != null && !string.isEmpty(); ++i) {
            Boolean bl = (Boolean)this.jtFileTable.getValueAt(i, 2);
            if (!bl.booleanValue()) continue;
            ++n2;
        }
        return n2;
    }

    private int getSelectedItem() {
        int n = this.jtFileTable.getSelectedRow();
        if (n < 0) {
            return -1;
        }
        return n;
    }

    private void removeMarkedOrSelectedItems(boolean bl) {
        int n = this.jtFileTable.getRowCount();
        if (n == 0) {
            return;
        }
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.jtFileTable.getModel();
        if (bl) {
            while (this.getMarkedColumnCount() > 0) {
                String string;
                for (int i = 0; i < n && (string = (String)this.jtFileTable.getValueAt(i, 1)) != null && !string.isEmpty(); ++i) {
                    Boolean bl2 = (Boolean)this.jtFileTable.getValueAt(i, 2);
                    if (!bl2.booleanValue()) continue;
                    defaultTableModel.removeRow(i);
                }
            }
        } else {
            int n2 = this.jtFileTable.getSelectedRow();
            if (n2 < 0) {
                return;
            }
            defaultTableModel.removeRow(n2);
        }
        this.reorganizeTableIndex();
    }

    private void changeMarkState(boolean bl, boolean bl2) {
        String string;
        int n = this.jtFileTable.getRowCount();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n && (string = (String)this.jtFileTable.getValueAt(i, 1)) != null && !string.isEmpty(); ++i) {
            Boolean bl3 = (Boolean)this.jtFileTable.getValueAt(i, 2);
            bl3 = bl2 ? Boolean.valueOf(bl3 == false) : Boolean.valueOf(bl);
            this.jtFileTable.setValueAt(bl3, i, 2);
        }
    }

    private void startEncryption() throws Exception {
        new CDoEncryptionThread(this);
    }

    @Override
    public boolean progressIndicator(int n, int n2) {
        this.jpb.setValue(n);
        return true;
    }

    public int getLastEntryRowIndex() {
        int n = 0;
        for (int i = 0; i < this.jtFileTable.getRowCount(); ++i) {
            String string = (String)this.jtFileTable.getValueAt(i, 1);
            if (string != null && !string.isEmpty()) continue;
            return i;
        }
        return n;
    }

    private void hexdumpCurrentlySelectedFile() {
        final int n = this.getSelectedItem();
        if (n < 0) {
            return;
        }
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        new CFileHexDump(new File((String)CFileCrypterGUI.this.jtFileTable.getValueAt(n, 1)));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }).start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    private void maybeShowPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && SwingUtilities.isRightMouseButton(mouseEvent) && (JTable)mouseEvent.getComponent() == this.jtFileTable) {
            this.jm.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getText().trim();
            String[] stringArray = new String[]{"Add", "Exi", "Rem", "Mar", "Unm", "Inv", "Sta", "Hex"};
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.startsWith(stringArray[i])) continue;
                switch (i) {
                    case 0: {
                        if (string.contains("direct")) {
                            this.addDirectoryToList();
                            break;
                        }
                        this.addFilesToList();
                        break;
                    }
                    case 1: {
                        this.dispose();
                        break;
                    }
                    case 2: {
                        this.removeMarkedOrSelectedItems(string.contains("arked"));
                        break;
                    }
                    case 3: {
                        this.changeMarkState(true, false);
                        break;
                    }
                    case 4: {
                        this.changeMarkState(false, false);
                        break;
                    }
                    case 5: {
                        this.changeMarkState(false, true);
                        break;
                    }
                    case 6: {
                        try {
                            this.startEncryption();
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    case 7: {
                        this.hexdumpCurrentlySelectedFile();
                    }
                }
                break;
            }
            return;
        }
        if (actionEvent.getSource() == this.jbStart) {
            try {
                this.startEncryption();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        if (actionEvent.getSource() == this.jbExit) {
            this.dispose();
            System.exit(1);
        }
        if (actionEvent.getSource() == this.jbCancel) {
            this.fileProcessInterrupter.interrupt();
            Boolean bl = this.canceled;
            synchronized (bl) {
                this.canceled = true;
            }
            return;
        }
        if (actionEvent.getSource() == this.jbAddFile) {
            this.addFilesToList();
            return;
        }
        if (actionEvent.getSource() == this.jrbBufKB || actionEvent.getSource() == this.jrbBufMB) {
            if (this.jrbBufKB.isSelected() && !this.oldStateKBSelected.booleanValue()) {
                int n = (Integer)this.jspBufSize.getValue();
                this.jspBufSize.setValue(1024 * n);
                this.oldStateKBSelected = true;
                this.oldStateMBSelected = false;
                this.jspBufSize.setModel(new SpinnerNumberModel(1024 * n, 16, 32768, 16));
                ((JSpinner.DefaultEditor)this.jspBufSize.getEditor()).getTextField().setEnabled(false);
                return;
            }
            if (this.jrbBufMB.isSelected() && !this.oldStateMBSelected.booleanValue()) {
                int n = (Integer)this.jspBufSize.getValue();
                n = n / 1024 > 0 ? n / 1024 : 1;
                this.jspBufSize.setValue(n);
                this.oldStateMBSelected = true;
                this.oldStateKBSelected = false;
                this.jspBufSize.setModel(new SpinnerNumberModel(n, 1, 512, 1));
                ((JSpinner.DefaultEditor)this.jspBufSize.getEditor()).getTextField().setEnabled(false);
                return;
            }
        }
    }

    public JMenuBar initMainMenu(String[] stringArray) {
        JMenuBar jMenuBar = new JMenuBar();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split(";");
            JMenu jMenu = new JMenu(stringArray2[0]);
            for (int j = 1; j < stringArray2.length; ++j) {
                if (stringArray2[j].charAt(0) == '-') {
                    jMenu.addSeparator();
                    continue;
                }
                JMenuItem jMenuItem = new JMenuItem(stringArray2[j]);
                jMenuItem.addActionListener(this);
                jMenu.add(jMenuItem);
            }
            jMenuBar.add(jMenu);
        }
        return jMenuBar;
    }

    class CEncrypterThread
    extends Thread {
        CFileEncrypter encrypter;
        boolean multiThreaded;
        int row;

        public CEncrypterThread(CFileEncrypter cFileEncrypter, boolean bl, int n) {
            this.encrypter = cFileEncrypter;
            cFileEncrypter.setMultiThreaded(bl);
            this.row = n;
            this.start();
        }

        @Override
        public void run() {
            try {
                this.encrypter.processFile();
                CFileCrypterGUI.this.jtFileTable.setValueAt(true, this.row, 3);
                CFileCrypterGUI.this.jtFileTable.remove(CFileCrypterGUI.this.jpb);
                CFileCrypterGUI.this.jtFileTable.updateUI();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class CDoEncryptionThread
    extends Thread {
        ArrayList<CFileToProcess> filesToProcessList = new ArrayList();
        String passwd;
        JFrame dParent;
        boolean bMultiThreaded;
        boolean compression;
        boolean compr7zip;
        int bufSizeKB;

        public CDoEncryptionThread(JFrame jFrame) throws Exception {
            this.dParent = jFrame;
            if (CFileCrypterGUI.this.getMarkedColumnCount() <= 0) {
                JOptionPane.showMessageDialog(jFrame, "Empty FileList or no items have been marked - please select mark/file for encryption progress!", "Selected File(s) missing", 1);
                return;
            }
            this.passwd = new String(CFileCrypterGUI.this.jtfPasswd.getPassword());
            if (this.passwd == null || this.passwd.isEmpty()) {
                JOptionPane.showMessageDialog(jFrame, "Empty password - please enter a valid password for the encryption process", "Password missing", 1);
                CFileCrypterGUI.this.jtfPasswd.requestFocus();
                return;
            }
            this.bMultiThreaded = CFileCrypterGUI.this.jcbMultiThread.isSelected();
            this.bufSizeKB = (Integer)CFileCrypterGUI.this.jspBufSize.getValue();
            if (CFileCrypterGUI.this.jrbBufMB.isSelected()) {
                this.bufSizeKB *= 1024;
            }
            this.compression = CFileCrypterGUI.this.jrbComp2.isSelected() || CFileCrypterGUI.this.jrbComp3.isSelected();
            this.compr7zip = false;
            if (this.compression) {
                this.compr7zip = CFileCrypterGUI.this.jrbComp3.isSelected();
            }
            int n = CFileCrypterGUI.this.jtFileTable.getRowCount();
            for (int i = 0; i < n; ++i) {
                String string = (String)CFileCrypterGUI.this.jtFileTable.getValueAt(i, 1);
                if (string == null || string.isEmpty() || !((Boolean)CFileCrypterGUI.this.jtFileTable.getValueAt(i, 2)).booleanValue()) continue;
                this.filesToProcessList.add(new CFileToProcess(string, i));
            }
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CFileCrypterGUI.this.jbStart.setEnabled(false);
            CFileCrypterGUI.this.jbCancel.setEnabled(true);
            Boolean bl = CFileCrypterGUI.this.canceled;
            synchronized (bl) {
                CFileCrypterGUI.this.canceled = false;
            }
            for (CFileToProcess cFileToProcess : this.filesToProcessList) {
                try {
                    CFileEncrypter cFileEncrypter = new CFileEncrypter(cFileToProcess, this.bufSizeKB, this.passwd);
                    cFileEncrypter.setCompression(this.compression, this.compr7zip);
                    cFileEncrypter.setProgressIndicator((IFileProgressIndicator)((Object)this.dParent));
                    CFileCrypterGUI.this.fileProcessInterrupter = cFileEncrypter;
                    CFileCrypterGUI.this.jtFileTable.getSelectionModel().setSelectionInterval(cFileToProcess.row, cFileToProcess.row);
                    Rectangle rectangle = CFileCrypterGUI.this.jtFileTable.getCellRect(cFileToProcess.row, 3, true);
                    CFileCrypterGUI.this.jpb = new JProgressBar(0, cFileEncrypter.getNumberOfBlocksToProcess());
                    CFileCrypterGUI.this.jtFileTable.add(CFileCrypterGUI.this.jpb);
                    CFileCrypterGUI.this.jpb.setBounds(rectangle);
                    CFileCrypterGUI.this.jpb.setForeground(Color.YELLOW);
                    CEncrypterThread cEncrypterThread = new CEncrypterThread(cFileEncrypter, this.bMultiThreaded, cFileToProcess.row);
                    while (!CFileCrypterGUI.this.canceled.booleanValue() && cEncrypterThread.isAlive()) {
                        Thread.sleep(100L);
                    }
                    if (!CFileCrypterGUI.this.canceled.booleanValue()) continue;
                    break;
                }
                catch (Exception exception) {
                }
            }
            CFileCrypterGUI.this.jbStart.setEnabled(true);
            CFileCrypterGUI.this.jbCancel.setEnabled(false);
        }
    }

    class CFileToProcess
    extends File {
        int row;

        public CFileToProcess(String string, int n) throws Exception {
            super(string);
            this.row = n;
        }
    }
}

