package net.nieden.FileCrypter;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
import javax.swing.table.*;

public class CFileCrypterGUI extends JFrame implements ActionListener, MouseListener, IFileProgressIndicator {
	private static final long serialVersionUID = 1L;
	JButton jbCancel = new JButton("Cancel"),
		jbStart = new JButton("Start"),
		jbAddFile = new JButton("Add file(s)"),
		jbExit = new JButton("Exit");
	JTable jtFileTable=new JTable();
	JScrollPane jspFileTable=new JScrollPane(jtFileTable,JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
	JLabel jlGroupBox1=new JLabel(""),
		jlGroupBox2=new JLabel(""),
		jlGroupBox3=new JLabel(""),
		jlGroupBox4=new JLabel(""),
		jlPasswd=new JLabel("Password"), jlBufSize=new JLabel("BufSize in");
	JPasswordField jtfPasswd=new JPasswordField();
	JRadioButton jrbComp1=new JRadioButton("None", true),
		jrbComp2=new JRadioButton("GZIP", false),
		jrbComp3=new JRadioButton("7-Zip", false),
		jrbBufKB=new JRadioButton("KB", true),
		jrbBufMB=new JRadioButton("MB", false);
	JCheckBox jcbMultiThread=new JCheckBox("enable MT", true);
	JLabel jlImage=new JLabel(new ImageIcon("Images/safe_into.png"));
	private JPopupMenu jm = new JPopupMenu();
	ButtonGroup bg1=new ButtonGroup(),bg2=new ButtonGroup();
	SpinnerModel model = new SpinnerNumberModel(256, //initial value
		16, //min
	 32768, //max
		16); //step
	JSpinner jspBufSize=new JSpinner(model);
	JProgressBar jpb;
	IFileProcessInterrupter fileProcessInterrupter=null;
	Boolean oldStateKBSelected=true,oldStateMBSelected=false, canceled=false;

	Object[] ctrlList = {
		jlGroupBox1 ,  2, 22,178, 86,
		jlGroupBox2 ,  2,114,595,368,
		jlGroupBox3 ,180, 22,110, 86,
		jlGroupBox4 ,290, 22,150, 86,
		jlImage     ,588,  2,128,128,
		jbStart     ,600,134,100, 19,
		jbCancel    ,600,154,100, 19,
		jbAddFile   ,600,174,100, 19,
		jbExit      ,600,194,100, 19,
		jspFileTable, 10,134,580,342,
		jlPasswd	, 10, 50,100, 24,
		jcbMultiThread,86,48, 90, 22,
		jtfPasswd   , 10, 72,160, 24,
		jlBufSize   ,300, 50, 80, 24,
		jspBufSize  ,300, 72, 80, 24,
		jrbComp1    ,188, 46, 90, 16,
		jrbComp2    ,188, 62, 90, 16,
		jrbComp3    ,188, 78, 90, 16,
		jrbBufKB    ,380, 62, 50, 16,
		jrbBufMB    ,380, 78, 50, 16,
		null
	};

	public CFileCrypterGUI() throws Exception {
		buildGUI();
	}

	public void buildGUI() throws Exception {
		String[] sColumnList = {
			"40;I;Nr.;0","320;S;Filename;0","50;B;Marked;1","60;B;Processed;0","100;I;Filesize;0"
		};
		// UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		setLayout(null);
		CFileTools.initTable(jtFileTable, sColumnList,80, true);
		for (int y=0;y<80;y++) jtFileTable.setValueAt(y+1, y, 0);
		for (int i=0;ctrlList[i]!=null;i+=5) {
			getContentPane().add((JComponent)ctrlList[i]);
			((JComponent)ctrlList[i]).setBounds((Integer)ctrlList[i+1],(Integer)ctrlList[i+2],(Integer)ctrlList[i+3],(Integer)ctrlList[i+4]);
			if ((JComponent)ctrlList[i] == jlGroupBox1) {
				jlGroupBox1.setBorder(BorderFactory.createTitledBorder("Security settings"));
			} else if ((JComponent)ctrlList[i] == jlGroupBox2) {
				jlGroupBox2.setBorder(BorderFactory.createTitledBorder("Select file(s) for encryption"));
			} else if ((JComponent)ctrlList[i] == jlGroupBox3) {
				jlGroupBox3.setBorder(BorderFactory.createTitledBorder("Compression"));
			} else if ((JComponent)ctrlList[i] == jlGroupBox4) {
				jlGroupBox4.setBorder(BorderFactory.createTitledBorder("Buffer Size"));
			} else if ((JComponent)ctrlList[i] instanceof JButton) {
				((JButton)ctrlList[i]).setRolloverEnabled(true);
				((JButton)ctrlList[i]).addActionListener(this);
				// ((JButton)ctrlList[i]).setUI(new PlasticButtonUI());
			} else if ((JComponent)ctrlList[i] instanceof JRadioButton) {
				if (Arrays.asList(jrbComp1, jrbComp2, jrbComp3).contains(ctrlList[i])) {
					bg1.add((JRadioButton)ctrlList[i]);
				} else {
					bg2.add((JRadioButton)ctrlList[i]);
					((JRadioButton)ctrlList[i]).addActionListener(this);
				}
			}
			((JComponent)ctrlList[i]).setVisible(true);
		}
		String[] sPopupMenuList = {
			"Add directory to list",
			"Add file(s) to list",
			"Remove selected item from list", "Remove marked item(s) from list",
			"",
			"Mark all items", "Unmark all items", "Invert mark state","Hexdump of currently selected file",
			"",
			"Start encryption",
			"",
			"Exit program"
		};
		for (int i=0;i<sPopupMenuList.length;i++) {
			if (!sPopupMenuList[i].isEmpty()) {
				JMenuItem jmi = jm.add(sPopupMenuList[i]);
				jmi.addActionListener(this);
			} else jm.addSeparator();
		}
		jtFileTable.addMouseListener(this);
		jtFileTable.getSelectionModel().setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		jbCancel.setEnabled(false);
		setResizable(false);
		setSize(720,550);
		setLocationRelativeTo(null);
		setVisible(true);
		
		CFileTools.setIconImageFromResource(this, "safe_into.png");
		setTitle(CFileCrypterGUI.class.getSimpleName());
		jtFileTable.updateUI();
		for (int i=0;ctrlList[i]!=null;i+=5) {
			((JComponent)ctrlList[i]).updateUI();
		}
		(((JSpinner.DefaultEditor)jspBufSize.getEditor()).getTextField()).setEnabled(false);
		JMenuBar jmb=initMainMenu(new String[] {
			"File;Add directory to list;Add files to List;-;Preferences;-;Exit", "Edit;Undo;-;Mark selected;Unmark Selected",
			"Tools;Show Hexdump of current selected file","Help;About"});
		setJMenuBar(jmb);
		jmb.updateUI();
	}

	private void addFileToTable(File f) {
		if (fileExistsInTable(f,true)) return;
		int y=getLastEntryRowIndex();
		jtFileTable.setValueAt(f.getAbsolutePath(), y, 1);
		jtFileTable.setValueAt(true, y, 2);
		jtFileTable.setValueAt(CFileTools.printDottedNumber(f.length()), y, 4);
	}

	private boolean fileExistsInTable(File f, boolean printWarning) {
		int n=jtFileTable.getRowCount();
		for (int y=0;y<n;y++) {
			String s=(String)jtFileTable.getValueAt(y, 1);
			if (s==null || s.isEmpty()) return false;
			if (s.equals(f.getAbsolutePath())) {
				if (printWarning) {
					JOptionPane.showMessageDialog(null, "Skipping file \""+f.getAbsolutePath()+"\" - already exists in table!","Skipping file",JOptionPane.WARNING_MESSAGE);
				}
				return true;
			}
		}
		return false;
	}

	private void addFilesToList() {
		JFileChooser jfChooser=new JFileChooser();
		jfChooser.setMultiSelectionEnabled(true);
		jfChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
		jfChooser.setCurrentDirectory(new File("."));
		int returnVal = jfChooser.showOpenDialog(this);
	    if(returnVal == JFileChooser.APPROVE_OPTION) {
	    	File[] fList=jfChooser.getSelectedFiles();
	    	for (File f: fList) {
	    		if (f.isFile() && f.length()>0)
	    			addFileToTable(f);
	    	}
	    }
	}

	private void addDirectoryToList() {
		new Thread(new Runnable() {
			public void run() {
				try {
					CDirChooser cd=new CDirChooser(new File(System.getProperty("user.dir")));
					if (cd.isPathSelected()) {
						File d=new File(cd.getPathSelected());
						for (File f: d.listFiles()) {
				    		if (f.isFile() && f.length()>0)
				    			addFileToTable(f);
						}
					}
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}).start();
	}

	private void reorganizeTableIndex() {
		int rowCount=jtFileTable.getRowCount();

		for (int y=0;y<rowCount;y++) {
			jtFileTable.setValueAt(y+1, y, 0);
		}
	}

	private int getMarkedColumnCount() {
		int y, mc, rowCount=jtFileTable.getRowCount();
		if (rowCount==0) return 0;

		for (y=mc=0;y<rowCount;y++) {
			String s=(String)jtFileTable.getValueAt(y, 1);
			if (s==null || s.isEmpty()) break;
			Boolean bm=(Boolean)jtFileTable.getValueAt(y, 2);
			if (bm) mc++;
		}
		return mc;
	}

	private int getSelectedItem() {
		int y;

		if ((y=jtFileTable.getSelectedRow())<0) return -1;
		return y;
	}

	private void removeMarkedOrSelectedItems(boolean marked) {
		int y, rowCount=jtFileTable.getRowCount();
		if (rowCount==0) return;

		DefaultTableModel dtm=(DefaultTableModel)jtFileTable.getModel();
		if (marked) {
			while (getMarkedColumnCount()>0) {
				for (y=0;y<rowCount;y++) {
					String s=(String)jtFileTable.getValueAt(y, 1);
					if (s==null || s.isEmpty()) break;
					Boolean bm=(Boolean)jtFileTable.getValueAt(y, 2);
					if (bm) dtm.removeRow(y);
				}
			}
		} else {
			if ((y=jtFileTable.getSelectedRow())<0) return;
			dtm.removeRow(y);
		}
		reorganizeTableIndex();
	}

	private void changeMarkState(boolean mark, boolean invert) {
		int y, rowCount=jtFileTable.getRowCount();
		if (rowCount==0) return;

		for (y=0;y<rowCount;y++) {
			
			String s=(String)jtFileTable.getValueAt(y, 1);
			if (s==null || s.isEmpty()) break;
			Boolean bm=(Boolean)jtFileTable.getValueAt(y, 2);
			if (invert)	bm=!bm;
			else bm=mark;
			jtFileTable.setValueAt(bm, y, 2);
		}
	}

	@SuppressWarnings("serial")
	class CFileToProcess extends File {
		int row;

		public CFileToProcess(String pathName, int row) throws Exception {
			super(pathName);
			this.row=row;
		}
	}

	class CDoEncryptionThread extends Thread {
		ArrayList<CFileToProcess> filesToProcessList=new ArrayList<CFileToProcess>();
		String passwd;
		JFrame dParent;
		boolean bMultiThreaded, compression, compr7zip;
		int bufSizeKB;

		public CDoEncryptionThread(JFrame dParent) throws Exception {
			/**
			 * 1st - check the number of marked items to proceed
			 */
			this.dParent=dParent;
			if (getMarkedColumnCount()<=0) {
				JOptionPane.showMessageDialog(dParent, "Empty FileList or no items have been marked - please select mark/file for encryption progress!","Selected File(s) missing",JOptionPane.INFORMATION_MESSAGE|JOptionPane.OK_OPTION);
				return;
			}
			passwd=new String(jtfPasswd.getPassword());
			if (passwd==null || passwd.isEmpty()) {
				JOptionPane.showMessageDialog(dParent, "Empty password - please enter a valid password for the encryption process","Password missing",JOptionPane.INFORMATION_MESSAGE|JOptionPane.OK_OPTION);
				jtfPasswd.requestFocus();
				return;
			}
			bMultiThreaded=jcbMultiThread.isSelected();
			bufSizeKB=(Integer)jspBufSize.getValue();
			if (jrbBufMB.isSelected()) bufSizeKB*=1024;
			compression=jrbComp2.isSelected() || jrbComp3.isSelected();
			compr7zip=false;
			if (compression) {
				compr7zip=jrbComp3.isSelected();
			}
			int rowCount=jtFileTable.getRowCount();
			for (int y=0;y<rowCount;y++) {
				String pathName;
				if ((pathName=(String)jtFileTable.getValueAt(y,1))!=null
					&&	!pathName.isEmpty() && (Boolean)(jtFileTable.getValueAt(y,2))) {
					filesToProcessList.add(new CFileToProcess(pathName, y));
				}
			}
			start();
		}

		public void run() {
			jbStart.setEnabled(false);
			jbCancel.setEnabled(true);
			synchronized (canceled) {
				canceled=false;
			}
			for (CFileToProcess cftp: filesToProcessList) {
				try {
					CFileEncrypter encrypter=new CFileEncrypter(cftp, bufSizeKB, passwd);
					encrypter.setCompression(compression, compr7zip);
					encrypter.setProgressIndicator((IFileProgressIndicator)dParent);
					fileProcessInterrupter=encrypter;
					jtFileTable.getSelectionModel().setSelectionInterval(cftp.row, cftp.row);
					Rectangle r=jtFileTable.getCellRect(cftp.row, 3, true);
					jtFileTable.add((jpb=new JProgressBar(0,encrypter.getNumberOfBlocksToProcess())));
					jpb.setBounds(r);
					jpb.setForeground(Color.YELLOW);
					CEncrypterThread cet=new CEncrypterThread(encrypter, bMultiThreaded, cftp.row);
					for (;;) {
						if (canceled) break;
						if (!cet.isAlive()) break;
						Thread.sleep(100);
					}
					if (canceled)
						break;
				} catch (Exception e) {
				}
			}
			jbStart.setEnabled(true);
			jbCancel.setEnabled(false);
		}
	}

	private void startEncryption() throws Exception {
		new CDoEncryptionThread(this);
	}

	class CEncrypterThread extends Thread {
		CFileEncrypter encrypter;
		boolean multiThreaded;
		int row;

		public CEncrypterThread(CFileEncrypter encrypter, boolean multiThreaded, int row) {
			this.encrypter=encrypter;
			encrypter.setMultiThreaded(multiThreaded);
			this.row=row;
			start();
		}

		public void run() {
			try {
				encrypter.processFile();
				jtFileTable.setValueAt(true, row, 3);
				jtFileTable.remove(jpb);
				jtFileTable.updateUI();
			} catch (Exception e) { }
		}
	}

	public boolean progressIndicator(int num, int max) {
		jpb.setValue(num);
		return true;
	}

	public int getLastEntryRowIndex() {
		int i=0;

		for (int y=0;y<jtFileTable.getRowCount();y++) {
			String s=(String)jtFileTable.getValueAt(y, 1);
			if (s==null || s.isEmpty()) return y;
		}
		return i;
	}

	private void hexdumpCurrentlySelectedFile() {
		final int y=getSelectedItem();
		if (y<0) return;
		try {
			new Thread(new Runnable() {
				public void run() {
					try {
						new CFileHexDump(new File((String)jtFileTable.getValueAt(y, 1)));
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
			}).start();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void mousePressed (MouseEvent e) { maybeShowPopup(e); }
	public void mouseReleased(MouseEvent e) { maybeShowPopup(e); }
	public void mouseClicked (MouseEvent e) { maybeShowPopup(e); }
	public void mouseEntered (MouseEvent e) { maybeShowPopup(e); }
	public void mouseExited  (MouseEvent e) { maybeShowPopup(e); }

	private void maybeShowPopup(MouseEvent e) {
		if (e.isPopupTrigger()) {
			if(SwingUtilities.isRightMouseButton(e)&&(JTable)e.getComponent()==jtFileTable) {
				jm.show(e.getComponent(),e.getX(),e.getY());
			}
		}
	}

	public void actionPerformed(ActionEvent a) {
		if (a.getSource() instanceof JMenuItem) {
			JMenuItem jmi=(JMenuItem)a.getSource();
			String s=jmi.getText().trim();
			String[] sMenuIdent = {
				"Add","Exi","Rem","Mar","Unm","Inv","Sta","Hex"	
			};

			for (int i=0;i<sMenuIdent.length;i++) {
				if (s.startsWith(sMenuIdent[i])) {
					switch(i) {
					case 0: // Add
						if (s.contains("direct")) {
							addDirectoryToList();
						} else addFilesToList(); break;
					case 1: // Exit
						dispose(); break;
					case 2: // Remove
						removeMarkedOrSelectedItems(s.contains("arked"));
						break;
					case 3: // Mark
						changeMarkState(true, false); break;
					case 4: // Unmark
						changeMarkState(false, false); break;
					case 5: // Invert
						changeMarkState(false, true); break;
					case 6: // Start encryption
						try {
							startEncryption();
						} catch (Exception e) { }
						break;
					case 7: // Hexdump
						hexdumpCurrentlySelectedFile();
						break;
					}
					break;
				}
			}
			return;
		}
		if (a.getSource()==jbStart) {
			try {
				startEncryption();
			} catch (Exception e) { }
			return;
		}
		if (a.getSource()==jbExit) {
			dispose();
			System.exit(1);
		}

		if (a.getSource()==jbCancel) {
			fileProcessInterrupter.interrupt();
			synchronized (canceled) {
				canceled=true;
			}
			return;
		}
		if (a.getSource()==jbAddFile) {
			addFilesToList();
			return;
		}
		if (a.getSource()==jrbBufKB || a.getSource()==jrbBufMB) {
			if (jrbBufKB.isSelected()&&!oldStateKBSelected) {
				int kb=(Integer)jspBufSize.getValue();
				jspBufSize.setValue(1024*kb);
				oldStateKBSelected=true; oldStateMBSelected=false;
				jspBufSize.setModel(new SpinnerNumberModel(1024*kb, //initial value
					16, //min
				 32768, //max
					16));
				(((JSpinner.DefaultEditor)jspBufSize.getEditor()).getTextField()).setEnabled(false);
				return;
			}
			if (jrbBufMB.isSelected()&&!oldStateMBSelected) {
				int mb=(Integer)jspBufSize.getValue();
				jspBufSize.setValue(mb=(mb/1024)>0?mb/1024:1);
				oldStateMBSelected=true; oldStateKBSelected=false;
				jspBufSize.setModel(new SpinnerNumberModel(mb, //initial value
					1, //min
				  512, //max
				    1)); //step
				(((JSpinner.DefaultEditor)jspBufSize.getEditor()).getTextField()).setEnabled(false);
				return;
			}
		}
	}

	public JMenuBar initMainMenu(String[] sMenuList) {
	    JMenuBar jb=new JMenuBar();
		for (int i=0;i<sMenuList.length;i++) {
			String[] sl = sMenuList[i].split(";");
			JMenu jm = new JMenu(sl[0]);
			for (int j=1;j<sl.length;j++) {
				if (sl[j].charAt(0)=='-') {
					jm.addSeparator();
				} else {
					JMenuItem jmi = new JMenuItem(sl[j]);
					jmi.addActionListener(this);
					jm.add(jmi);
				}
			}
			jb.add(jm);
		}
		return jb;
	}
}
