package net.nieden.FileCrypter;

import java.awt.*;
import java.io.*;
import javax.swing.*;

public class CFileCrypterHexdump extends JFrame {
	final static int MAX_ROWS=64, COLUMNS=32;
	private static final long serialVersionUID = 2L;
	JTextArea jtaHexdump=new JTextArea();
	JScrollPane jspHexdump=new JScrollPane(jtaHexdump,JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
	File f;
	RandomAccessFile raf;

	public CFileCrypterHexdump(String fileName) throws Exception {
		f=new File(fileName);
		if (!f.isFile()) throw new Exception (fileName+" is NOT a regular file!");
		raf=new RandomAccessFile(f, "r");
		buildGUI();
		hexDump(0L);
	}

	public void buildGUI() throws Exception {
		setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		setLayout(new GridLayout(1, 1));
		jtaHexdump.setFont(new Font("Courier",Font.BOLD,12));
		getContentPane().add(jspHexdump);
		setSize(1024,768);
		setResizable(false);
		setLocationRelativeTo(null);
		jtaHexdump.setEditable(false);
		setVisible(true);
	}

	public void hexDump(long offset) throws Exception {
		if (offset >= f.length()) return;
		long bytesToProcess=f.length()-offset;
		long linesToProcess=bytesToProcess/COLUMNS;
		int lastItems=(int)bytesToProcess%COLUMNS;
		if (lastItems>0) linesToProcess++;
		byte[] buffer=new byte[(int)f.length()];
		raf.seek(offset);
		raf.read(buffer, 0, (int)f.length());
		System.out.printf("%d byte(s) read.\n", f.length());
		System.out.flush();
		
		System.out.printf("%d lines to process ... buffer.length=%d\n",
			linesToProcess, buffer.length);
		StringBuffer sb=new StringBuffer((int)(f.length()+linesToProcess));
		for (int y=0;y<linesToProcess;y++) {
			sb.append(String.format("%08x: ", offset+y*COLUMNS));
			for (int x=0;x<COLUMNS;x++) {
				boolean bEmpty=((y+1)==linesToProcess && lastItems > 0);
				if (bEmpty) {
					sb.append("   ");
				} else sb.append(String.format("%02x ", buffer[y*COLUMNS+x]&0xff));
				if ((x+1)==(COLUMNS/2))
					sb.append("- ");
			}
			for (int x=0;x<COLUMNS;x++) {
				boolean bEmpty=((y+1)==linesToProcess && lastItems > 0);
				if (bEmpty) break;
				int ch=buffer[y*COLUMNS+x]&0xff;
				boolean print=(ch >= 32 && ch < 192);
				sb.append(String.format("%c", (print)?ch:'.'));
			}
			sb.append("\n");
		}
		System.out.println("Setting TEXT ..."); System.out.flush();
		jtaHexdump.setText(sb.toString());
		jtaHexdump.updateUI();
	}

	public static void main(String[] args) {
		if (args.length < 1) return;
		try {
			for (String s: args) {
				new CFileCrypterHexdump(s);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
