package net.nieden.FileCrypter;

import java.io.*;
import java.awt.*;
import java.awt.Dialog.ModalExclusionType;
import java.awt.event.*;

import javax.swing.*;

public class CFileHexDump extends JFrame implements ActionListener, AdjustmentListener {
	private static final long serialVersionUID = 3L;
	RandomAccessFile raf;
	JScrollPane jspOffset, jspHexDump, jspText; 
	long lOffset=0, lFileSize;
	JTable jtOffset=new JTable(), jtHexdump=new JTable(), jtText=new JTable();
	JScrollBar jsb=new JScrollBar();

	public CFileHexDump(File f)  throws Exception {
		super("Hexdump of \""+f.getName()+"\"");
		lFileSize=f.length();
		raf=new RandomAccessFile(f,"r");
		buildGUI();
		displayBuffer();
	}

	public void buildGUI() throws Exception {
		Font font=new Font("Courier",Font.BOLD,17);
		jspOffset=new JScrollPane(jtOffset,JScrollPane.VERTICAL_SCROLLBAR_NEVER,JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		jspHexDump=new JScrollPane(jtHexdump,JScrollPane.VERTICAL_SCROLLBAR_NEVER,JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		jspText=new JScrollPane(jtText,JScrollPane.VERTICAL_SCROLLBAR_NEVER,JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		setLayout(null);
		setSize(800,600);
		setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		jspOffset.setBounds(10, 10, 100, 532);
		jspHexDump.setBounds(120, 10, 468, 532);
		jspText.setBounds(595, 10, 172, 532);
		jsb.setBounds(770,10,18,532);
		getContentPane().add(jspOffset); getContentPane().add(jspHexDump);
		getContentPane().add(jspText);
		getContentPane().add(jsb);
		CFileTools.initTable(jtOffset, new String[]{"100;S;Offset"}, 32, false, font);
		CFileTools.initTable(jtText, new String[]{"170;S;ASCII"}, 32, false, font);
		String[] sList=new String[17];
		for (int i=0;i<17;i++) {
			if (i!=8) sList[i]=String.format("28;I;%02x",i<8?i:i-1);
			else sList[i]="32;S; - ";
		}
		CFileTools.initTable(jtHexdump, sList, 32, false, font);
		setLocationRelativeTo(null);
		CFileTools.setIconImageFromResource(this, "geany.png");
		setResizable(false);
		setVisible(true);
		jspText.getVerticalScrollBar().setMaximum(2);
		jsb.addAdjustmentListener(this);
		jsb.setMaximum((int)lFileSize/16);
		setModalExclusionType(ModalExclusionType.TOOLKIT_EXCLUDE);
	}

	public void displayBuffer() throws Exception {
		byte[] buffer=new byte[512];

		raf.seek(lOffset);
		int n=raf.read(buffer,0,buffer.length),	y_sz=n/16, x_sz=n%16;
		if (x_sz > 0) y_sz++;
		for (int y=0;y<32;y++) {
			if (y >= y_sz) {
				jtOffset.setValueAt("", y, 0);
				for (int x=0;x<17;x++) {
					jtHexdump.setValueAt("", y, x);
				}
				jtText.setValueAt("", y, 0);
				continue;
			}
			String s=String.format("%09x", lOffset+16*y);
			jtOffset.setValueAt(s, y, 0);
			int lastColumn=((y+1)==y_sz && x_sz > 0)?x_sz:16;
			jtHexdump.setValueAt(" -", y, 8);
			String st="";
			for (int x=0;x<16;x++) {
				int ch=buffer[y*16+x]&0xff;
				s=(x<lastColumn)?String.format("%02x",ch):"";
				jtHexdump.setValueAt(s, y, (x<8)?x:x+1);
				st+=(ch < 32)?".":String.format("%c", ch);
			}
			jtText.setValueAt(st, y, 0);
		}
	}

	public void actionPerformed(ActionEvent event) {
	}

	public void adjustmentValueChanged(AdjustmentEvent adjEvent) {
		int v=adjEvent.getValue();
		lOffset=16*v;
		try {
			displayBuffer();
		}catch (Exception e) {
			e.printStackTrace();
		}
	}

	public static void main(String[] args) {
		if (args.length>0) {
			for (String s: args) {
				File f=new File(s);
				if (f.isFile()) {
					try {
						new CFileHexDump(f);
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
			}
		}
	}
}
