#ifndef PIMPL_RECTANGLE_H__
#define PIMPL_RECTANGLE_H__

#include "shape.h"

class QRectF;

class Rectangle : public Shape {
public:
    Rectangle();
    explicit Rectangle( const QRectF & r );
    ~Rectangle();

    /* reimp */ Rectangle * clone() const;

    QRectF rect() const;
    void setRect( const QRectF & rect );

protected:
    // defined in rectangle_p.h:
    class Private;
    inline Private * d_func();
    inline const Private * d_func() const;
    inline explicit Rectangle( Private * );
};

#endif /* PIMPL_RECTANGLE_H__ */
