#ifndef PIMPL_ELLIPSE_P_H__
#define PIMPL_ELLIPSE_P_H__

#include "ellipse.h"
#include "shape_p.h"

#include <QPointF>

class Ellipse::Private : public Shape::Private {
    friend class ::Ellipse;
    QPointF center;
    double a, b;
public:
    Ellipse * q_func() { return static_cast<Ellipse*>( Shape::Private::q_func() ); }
    const Ellipse * q_func() const { return static_cast<const Ellipse*>( Shape::Private::q_func() ); }

    explicit Private( const QPointF & center, double a, double b, Ellipse * qq )
        : Shape::Private( qq ),
          center( center ), a( a ), b( b )
    {
        // don't touch 'q_func' here!
    }

    void init() {}

    /* reimp */ void doDraw( QPainter * p ) const;
};

Ellipse::Private * Ellipse::d_func() { return static_cast<Private*>( Shape::d_func() ); }
const Ellipse::Private * Ellipse::d_func() const { return static_cast<const Private*>( Shape::d_func() ); }

Ellipse::Ellipse( Private * d )
    : Shape( d )
{

}

#endif /* PIMPL_ELLIPSE_P_H__ */
