#ifndef PIMPL_SHAPE_H__
#define PIMPL_SHAPE_H__

class QPainter;
class QPen;
class QBrush;

class Shape {
public:
    Shape();
    virtual ~Shape();

    void draw( QPainter * p ) const;

    void setPen( const QPen & pen );
    const QPen & pen() const;

    void setBrush( const QBrush & brush );
    const QBrush & brush() const;

protected:
    // defined in shape_p.h:
    class Private;
    Private * d_func() { return _d; }
    const Private * d_func() const { return _d; }
    inline explicit Shape( Private * );
private:
    Private * _d;
};

#endif /* PIMPL_SHAPE_H__ */
