package loginexample.controller
{
	import loginexample.model.ConfigProxy;
	import loginexample.model.UserProxy;
	import loginexample.view.ApplicationMediator;
	
	import org.puremvc.as3.interfaces.ICommand;
	import org.puremvc.as3.interfaces.INotification;
	import org.puremvc.as3.patterns.command.SimpleCommand;

	public class StartupCommand extends SimpleCommand implements ICommand
	{
		
		override public function execute(notification:INotification):void
		{
			
			var appview:PMVC_Login = notification.getBody() as PMVC_Login;
			
			/*
			 * Registriere App Mediator
			 */
			facade.registerMediator( new ApplicationMediator( appview ) );
			
			//Registriere Proxies
			facade.registerProxy( new UserProxy() );
			facade.registerProxy( new ConfigProxy() );
			
			/*
			 * Lade Config
			 */
			var configproxy:ConfigProxy = facade.retrieveProxy( ConfigProxy.NAME ) as ConfigProxy;
			configproxy.loadConfig();
			
		}
		
	}
}