﻿using System;
using System.Collections.ObjectModel;
using System.Linq;
using WWWings_Dienstproxies.WWWingsServer;
using WWWings_GO;

public partial class Buchung_OhneAJAX : System.Web.UI.Page
{
 
 Passagier Passagier;
 Flug Flug;
 ObservableCollection<Flug> Fluege;
 ObservableCollection<Passagier> Passagiere;
 BuchungsServiceClient client;
 // --------------------------------------------------------------------------------------------------

 protected void Page_Load(object sender, EventArgs e)
 {
  client = new BuchungsServiceClient();

  if (!Page.IsPostBack)
  {  // Auswahlfelder befüllen, das aber nur beim ersten Laden der Seite!
   var Flughaefen = client.GetFlughaefen();
   this.C_Abflugort.DataSource = Flughaefen;
   this.C_Zielort.DataSource = Flughaefen;
   this.DataBind();
  }

   // Wenn ein Passagier neu angelegt wurde, zeige diesen an
  if (Session["Passagier"] != null && Session["Passagier"] is Passagier)
  {
    Passagiere = new ObservableCollection<Passagier> { Session["Passagier"] as Passagier };

   // Datenbindung an Tabelle
   this.C_GefundenePassagiere.DataSource = Passagiere;
   this.C_GefundenePassagiere.DataBind();
   // wähle diesen Passagier aus
   this.C_GefundenePassagiere.SelectedIndex = 0;
   // setze die Merk-Variable zurück
   Session["Passagier"] = null;

  }

  // Wenn ein Flug vor dem Anlegen des Passagiers ausgewählt war, zeige diesen an
  if (Session["GewaehlterFlug"] != null)
  {
   Flug = client.GetFlug((int)Session["GewaehlterFlug"]);
   Fluege = new ObservableCollection<Flug> { Flug };
   // Datenbindung an Tabelle
   this.C_GefundeneFluege.DataSource = Fluege;
   this.C_GefundeneFluege.DataBind();
   // wähle diesen Flug aus
   this.C_GefundeneFluege.SelectedIndex = 0;
   // setze die Merk-Variable zurück
   Session["GewaehlterFlug"] = null;
  }
 }

 protected void Page_Unload(object sender, EventArgs e)
 {
  client.Close();
 }


 // --------------------------------------------------------------------------------------------------
 protected void C_FlugSuchen_Click(object sender, EventArgs e)
 {
  this.C_BuchenErgebnis.Text = "";
  int FNr;
  if (Int32.TryParse(this.C_Flugnummer.Text, out FNr))
  {
   Flug = client.GetFlug(FNr);
   Fluege = new ObservableCollection<Flug> { Flug };
  }
  else
  {
   Fluege = client.GetFluege(this.C_Abflugort.Text, this.C_Zielort.Text);
  }

  // Datenbindung an Tabelle
  this.C_GefundeneFluege.DataSource = Fluege;
  this.C_GefundeneFluege.DataBind();
 }

 // --------------------------------------------------------------------------------------------------
 protected void C_PassagierSuchen_Click(object sender, EventArgs e)
 {
  this.C_BuchenErgebnis.Text = "";
  int PID;
  if (Int32.TryParse(this.C_PassagierID.Text, out PID))
  {
   Passagier = client.GetPassagier(PID);
   if (Passagier != null) Passagiere = new ObservableCollection<Passagier> { Passagier };
  }
  else
  {
   Passagiere = client.GetPassagiere(this.C_Passagiername.Text);
  }

  if (Passagiere != null) Passagiere = new ObservableCollection<WWWings_GO.Passagier>(Passagiere.OrderBy(x => x.GanzerName));

  // Datenbindung an Tabelle
  this.C_GefundenePassagiere.DataSource = Passagiere;
  this.C_GefundenePassagiere.DataBind();

 }

 // --------------------------------------------------------------------------------------------------
 protected void C_Buchen_Click(object sender, EventArgs e)
 {
  // Wurde etwas ausgewählt?
  if (this.C_GefundeneFluege.SelectedIndex < 0 || this.C_GefundenePassagiere.SelectedIndex < 0)
  {
   this.C_BuchenErgebnis.Text = "Auswahl nicht korrekt";
   return;
  }

  // Ermittele Schlüsselwerte der gewählten Zeilen
  int? FlugID = (int)this.C_GefundeneFluege.SelectedDataKey[0];
  int? PassagierID = (int)this.C_GefundenePassagiere.SelectedDataKey[0];

  try
  {
   string ergebnis = client.CreateBuchung(FlugID.Value, PassagierID.Value);
   if (ergebnis == "OK")
   {
    this.C_BuchenErgebnis.Text = "Buchung erfolgreich!";
    this.C_BuchenErgebnis.ForeColor = System.Drawing.Color.Green;
   }
   else
   {
    this.C_BuchenErgebnis.Text = ergebnis;
    this.C_BuchenErgebnis.ForeColor = System.Drawing.Color.Red;
   }
  }
  catch (Exception ex)
  {
   this.C_BuchenErgebnis.Text = "Fehler beim Aufruf der Buchungsfunktion: " + ex.Message;
   this.C_BuchenErgebnis.ForeColor = System.Drawing.Color.Red;
  }

 }
 // --------------------------------------------------------------------------------------------------
 protected void Page_PreRender(object sender, EventArgs e)
 {
  // Schaltfläche aktivieren, wenn Buchung möglich!
  this.C_Buchen.Enabled = (this.C_GefundeneFluege.SelectedIndex >= 0 && this.C_GefundenePassagiere.SelectedIndex >= 0);
 }
 // --------------------------------------------------------------------------------------------------
 protected void C_NeuerPassagier_Click(object sender, EventArgs e)
 {
  // gewählten Flug merken
  if (this.C_GefundeneFluege.SelectedIndex > 0) Session["GewaehlterFlug"] = (int)this.C_GefundeneFluege.SelectedDataKey[0];
  // Weitergabe an neue Seite
  Response.Redirect("NeuerPassagier.aspx");
 }
}
