﻿using System;
using System.IO;
using System.Reflection;
using WWWings_GL;
using WWWings_GO;

namespace WWWings_Dienste
{
 /// <summary>
 /// Dienstimplementierug
 /// </summary>
 public class BuchungsService : IBuchungsService, IDisposable
 {
  #region IBuchungsservice Members

  BuchungsManager bm = new BuchungsManager();

  public GetFlugAntwort GetFlug(GetFlugAnfrage anfrage)
  {
   return new GetFlugAntwort() { Flug = bm.GetFlug(anfrage.FlugNummer) };
  }

  public GetPassagierAntwort GetPassagier(GetPassagierAnfrage anfrage)
  {
   return new GetPassagierAntwort() { Passagier = bm.GetPassagier(anfrage.PassagierNummer) };
  }

  public GetFluegeAntwort GetFluege(GetFluegeAnfrage anfrage)
  {
   return new GetFluegeAntwort() { Fluege = bm.GetFluege(anfrage.Abflugort, anfrage.Zielort) };
  }

  public GetPassagiereAntwort GetPassagiere(GetPassagiereAnfrage Anfrage)
  {
   return new GetPassagiereAntwort() { Passagiere = bm.GetPassagiere(Anfrage.Namensbestandteil) };
  }

  public SavePassagierSetAntwort SavePassagierSet(SavePassagierSetAnfrage anfrage)
  {
   var Antwort = new SavePassagierSetAntwort();
   string statistik;
   Antwort.NeuePassagiere = bm.SavePassagierSet(anfrage.PassagierSet, out statistik);
   Antwort.Statistik = statistik;
   return Antwort;
  }

  public CreateBuchungAntwort CreateBuchung(CreateBuchungAnfrage anfrage)
  {
   return new CreateBuchungAntwort() { Status = bm.CreateBuchung(anfrage.FlugID, anfrage.PassagierID) };
  }

  public GetFlughaefenAntwort GetFlughaefen(GetFlughaefenAnfrage Anfrage)
  {
   return new GetFlughaefenAntwort() { FlughaefenNamen = bm.GetFlughaefen() };
  }

  #endregion

  #region IDisposable Members

  public void Dispose()
  {
   bm.Dispose();
  }

  #endregion

  public GetFotoAntwort GetFoto(GetFotoAnfrage Anfrage)
  {
   string pfad = Path.Combine(Path.GetDirectoryName(new Uri(Assembly.GetExecutingAssembly().CodeBase).AbsolutePath), "Bilder\\" + Anfrage.Ort.Replace('/', ' ') + ".jpg");
   return new GetFotoAntwort() { Foto = new FileStream(pfad, FileMode.Open, FileAccess.Read) };
  }
 }
}
