#!/usr/bin/perl
# cowboy.pl

use Getopt::Long;

# constants

my $v_progress = ".v.e.r.i.f.y.i.n.g...s.i.g.n.a.t.u.r.e.s......";
my $na_progress = ".c.o.l.l.e.c.t.i.n.g...s.i.g.n.a.t.u.r.e...i.n.f.o.r.m.a.t.i.o.n......";

if ((@ARGV < 1) || (!GetOptions('na' => \$param_na, 'v' => \$param_v)))
{
	die "Usage:\n-na for non-Apple-signed Apps\n-v for verification of signatures\n\n"; 
}

my @app_list = qx/ls \/Applications | grep \\.app/;
my $output = '';
my $app_count = 0;

print "\n>";

foreach $app (@app_list)
{
	chomp($app);
	$app =~ s/ /\\ /gsi;
	
	if ($param_na)
	{
		my $command = "codesign -d -vvv \/Applications\/${\($app)} 2>&1";
		$sign_list = qx($command);
		
		my $is_signed = "";
		if ($sign_list =~ m/not signed/gsi)
		{
			$is_signed = "not signed";
		}
		else
		{
			$is_signed = "signed by ";
		}
		
		$authority_chain = "";
		while ($sign_list =~ m/\QAuthority=\E([A-Za-z \.\,0-9\-]+?)\n/gsi)
		{
			$authority_chain .= $1 . "/";
		}
		$authority_chain =~ s/\/$//;
		
		if ($sign_list =~ m/\QIdentifier=\E(.*?)\nFormat/gsi)
		{
			$identifier = $1;
		}
		else
		{	
			$identifier = "no identifier";
			$app = "-> " . $app;
		}
		$app =~ s/\\ / /gsi;
		
		print substr($na_progress, ($app_count % length($na_progress)), 1);
		if ($authority_chain !~ m/Apple Root CA/)
		{
			$output .= $app . ": " . $is_signed . $authority_chain . ", " . $identifier . "\n";
		}
	}
	elsif ($param_v)
	{
		my $command = "codesign --verify \/Applications\/${\($app)} 2>&1";
		$sign_list = qx($command);
		$app =~ s/\\ / /gsi;
		
		print substr($v_progress, ($app_count % length($v_progress)), 1);
		if ($sign_list =~ m/(invalid signature)/gsi)
		{
			$is_signed = "$1";
			$app = "-> " . $app;
			$output .= $app . ": " . $is_signed . "\n";
		}
		
	}
	
	$app_count++;
}

print "...>.done.";

if ($output eq '')
{
	$output = "No problems found.\n\n";
}	
		
print "\n\n# Result of Evaluation:\n\n", $output, "\n";

#exit();