//
//  RBRecipeListViewController.m
//  Rezeptbuch
//
//  Created by Robert Böhnke on 10/30/12.
//  Copyright (c) 2012 Robert Böhnke. All rights reserved.
//

#import "RBRecipeListViewController.h"

#import "RBConstants.h"
#import "RBRecipeCell.h"
#import "RBRecipeViewController.h"

NSString * RBRecipeListViewReuseIdentifier = @"RBRecipeListViewReuseIdentifier";

@interface RBRecipeListViewController ()

@property (readwrite, strong) NSArray *recipes;

- (NSString *)accessibilityLabelForRecipe:(RBRecipe *)recipe;

@end

@implementation RBRecipeListViewController

#pragma mark - UIViewController

- (void)viewDidLoad
{
    self.title = NSLocalizedString(@"Rezepte", nil);

    NSString *bundlePath  = NSBundle.mainBundle.bundlePath;
    NSString *recipeList  = [bundlePath stringByAppendingPathComponent:@"RecipeList.plist"];
    NSArray *dictionaries = [NSArray arrayWithContentsOfFile:recipeList];

    NSMutableArray *recipes = [[NSMutableArray alloc] init];
    for (NSDictionary *dictionary in dictionaries) {
        RBRecipe *recipe = [[RBRecipe alloc] initWithDictionary:dictionary];
        [recipes addObject:recipe];
    }

    self.recipes = recipes;

    [self.tableView registerNib:[UINib nibWithNibName:@"RBRecipeCell" bundle:nil]
         forCellReuseIdentifier:RBRecipeListViewReuseIdentifier];
}

#pragma mark - UITableViewDataSource

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 1;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.recipes.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    RBRecipeCell *cell = [self.tableView dequeueReusableCellWithIdentifier:RBRecipeListViewReuseIdentifier
                                                              forIndexPath:indexPath];

    RBRecipe *recipe     = self.recipes[indexPath.row];
    cell.titleLabel.text = recipe.title;

    switch (recipe.healthiness) {
        case RBRecipeHealthinessGood:
            cell.trafficLight.image = [UIImage imageNamed:@"plus"];
            break;

        case RBRecipeHealthinessAverage:
            cell.trafficLight.image = [UIImage imageNamed:@"dot"];
            break;

        case RBRecipeHealthinessBad:
            cell.trafficLight.image = [UIImage imageNamed:@"minus"];
            break;
    }

    cell.accessibilityLabel = [self accessibilityLabelForRecipe:recipe];

    return cell;
}

#pragma mark - UITableViewDelegate

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    RBRecipe *recipe = self.recipes[indexPath.row];
    RBRecipeViewController *viewController = [[RBRecipeViewController alloc] initWithRecipe:recipe];

    [self.navigationController pushViewController:viewController animated:YES];
}

#pragma mark - RBRecipeListViewController

- (NSString *)accessibilityLabelForRecipe:(RBRecipe *)recipe
{
    NSMutableString *result = [recipe.title mutableCopy];

    switch (recipe.healthiness) {
        case RBRecipeHealthinessGood:
            [result appendFormat:@", %@", NSLocalizedString(@"Gesund", nil)];
            break;

        case RBRecipeHealthinessAverage:
            [result appendFormat:@", %@", NSLocalizedString(@"Durschnittlich", nil)];
            break;

        case RBRecipeHealthinessBad:
            [result appendFormat:@", %@", NSLocalizedString(@"Ungesund", nil)];
            break;
    }

    return result;
}

@end
