//
//  CTPCollectionViewLayout.m
//  PhotoViewer
//
//  Created by Richard Kurz on 12.06.13.
//  Copyright (c) 2013 Nobody. No rights reserved.
//

#import "CTPCollectionViewLayout.h"


@implementation CTPCollectionViewLayout
{
  CGSize contentSize;
  NSInteger maxRows, maxCols;
}


- (id) init
{
  if (!(self = [super init])) return nil;
  
  _itemSize = CGSizeMake(75.0, 50.0);
  
  return self;
}


- (id) initWithCoder: (NSCoder*) aDecoder
{
  if (!(self = [super initWithCoder: aDecoder])) return nil;
  
  return self;
}


- (void) prepareLayout
{
  [super prepareLayout];
  
  contentSize = CGSizeZero;
  maxCols = 0;
  maxRows = [self.collectionView numberOfSections];
  
  if (maxRows)
  {
    for (NSInteger row = 0; row < maxRows; row += 1)
    {
      NSInteger cols = [self.collectionView numberOfItemsInSection: row];
      if (cols > maxCols) maxCols = cols;
    }
    
    contentSize = CGSizeMake(maxCols * _itemSize.width, maxRows * _itemSize.height);
  }
}


- (CGSize) collectionViewContentSize
{
  return contentSize;
}


- (BOOL) shouldInvalidateLayoutForBoundsChange: (CGRect) newBounds
{
  return NO;
}


- (UICollectionViewLayoutAttributes*) layoutAttributesForItemAtIndexPath: (NSIndexPath*) path
{
  UICollectionViewLayoutAttributes* attributes = [UICollectionViewLayoutAttributes layoutAttributesForCellWithIndexPath: path];
  attributes.frame = CGRectMake(path.item * _itemSize.width, path.section * _itemSize.height, _itemSize.width, _itemSize.height);

  return attributes;
}


- (NSArray*) layoutAttributesForElementsInRect: (CGRect) rect
{
  NSMutableArray* layoutAttributes = [NSMutableArray array];
  
  rect = CGRectIntersection(rect, CGRectMake(0.0, 0.0, contentSize.width, contentSize.height));
  
  NSInteger fstRow = floor(rect.origin.y / _itemSize.height);
  NSInteger lstRow = ceil(CGRectGetMaxY(rect) / _itemSize.height);
  NSInteger fstCol = floor(rect.origin.x / _itemSize.width);
  NSInteger lstCol = ceil(CGRectGetMaxX(rect) / _itemSize.width);
  
  for (NSInteger row = fstRow; row < lstRow; row += 1)
  {
    NSInteger maxCol = [self.collectionView numberOfItemsInSection: row];
    if (lstCol < maxCol) maxCol = lstCol;
    
    for (NSInteger col = fstCol; col <  maxCol; col += 1)
    {
      [layoutAttributes addObject: [self layoutAttributesForItemAtIndexPath: [NSIndexPath indexPathForItem: col inSection: row]]];
    }
  }
  
  return layoutAttributes;
}


@end
