//
//  CTPSelectedBackgroundView.m
//  PhotoViewer
//
//  Created by Richard Kurz on 12.06.13.
//  Copyright (c) 2013 Nobody. No rights reserved.
//

#import "CTPSelectedBackgroundView.h"


@implementation CTPSelectedBackgroundView


- (void) drawRect: (CGRect) rect
{
  CGContextRef context = UIGraphicsGetCurrentContext();
  CGContextSaveGState(context);
  
  [[UIColor blackColor] setFill];
  [[UIColor redColor] setStroke];
  
  UIBezierPath* bezierPath = [UIBezierPath bezierPathWithRect: rect];
  [bezierPath setLineWidth: 5.0];
  
  [bezierPath fill];
  [bezierPath stroke];
  
  CGContextRestoreGState(context);
}


@end
