//
//  DKMainWindowController.m
//  Demoprojekt
//
//  Created by Kai on 23.9.13.
//  Copyright (c) 2013 Hippocampus Software GmbH. All rights reserved.
//

#import "DKMainWindowController.h"
#import "DKHeaderViewController.h"
#import "DKBodyViewController.h"
#import "DKAppDelegate.h"


@interface DKMainWindowController ()

@property (nonatomic, readwrite, weak)  IBOutlet NSView* headerContainer;
@property (nonatomic, readwrite, weak)  IBOutlet NSView* bodyContainer;

@end

@implementation DKMainWindowController

- (id) init
{
    return [self initWithWindowNibName:@"DKMainWindow"];
}

- (void)windowDidLoad
{
    [super windowDidLoad];
    
    NSAssert (_headerContainer, @"missing outlet connection");
    NSAssert (_bodyContainer, @"missing outlet connection");
    
    [self setupHeaderView];
    [self setupBodyView];
}

- (void) setupHeaderView
{
    // Als Beispiel für Produktvarianten wird die Kopfzeile nur in der Vollversion installiert.
    // Die globale Variable 'productVariant' wird vom Application-Delegate aus der info.plist gefüttert.
    if ([productVariant isEqualToString:@"full"]) {
        DKHeaderViewController* headerViewController = self.headerViewController;
        [self installView:headerViewController.view inContainerView:_headerContainer];
    }
    else {
        // Ohne Inhalt braucht der Container-View für die Kopfzeile ein Höhenconstraint, das ihn auf nichts zusammen-
        // schrumpft.
        NSDictionary* views = NSDictionaryOfVariableBindings (_headerContainer);
        NSArray* constraints = [NSLayoutConstraint constraintsWithVisualFormat:@"V:[_headerContainer(==0)]"
                                                                       options:NSLayoutFormatDirectionLeadingToTrailing
                                                                       metrics:nil
                                                                         views:views];
        [_headerContainer addConstraints:constraints];
    }
}

- (void) setupBodyView
{
    DKBodyViewController* bodyViewController = self.bodyViewController;
    [self installView:bodyViewController.view inContainerView:_bodyContainer];
}

- (void) installView:(NSView*)view inContainerView:(NSView*)containerView
{
    NSParameterAssert (view);
    NSParameterAssert (containerView);
    
    view.translatesAutoresizingMaskIntoConstraints = NO;    // zur Sicherheit, macht nur Ärger mit eigenen Constraints
    [containerView addSubview:view];
    
    // Mit vier Constraints wird der innere View füllend an seinen Container-View gebunden.
    NSDictionary* views = NSDictionaryOfVariableBindings (view);
    NSArray* constraints = [NSLayoutConstraint constraintsWithVisualFormat:@"H:|[view]|"
                                                                   options:NSLayoutFormatDirectionLeadingToTrailing
                                                                   metrics:nil
                                                                     views:views];
    [containerView addConstraints:constraints];
    
    constraints = [NSLayoutConstraint constraintsWithVisualFormat:@"V:|[view]|"
                                                          options:NSLayoutFormatDirectionLeadingToTrailing
                                                          metrics:nil
                                                            views:views];
    [containerView addConstraints:constraints];
}

// Die Controller für die Unterstruktur werden erst angelegt, wenn sie gebraucht werden. Dieser Stil unterstützt
// schnelle Startzeiten und spart Speicher: in diesem Fall wird für die Light-Version weder der Controller für die
// Kopfzeile angelegt noch das zugehörtige NIB geladen.

@synthesize headerViewController = _headerViewController;   // kein Auto-Synthesize da Accessor überschrieben ist

- (DKHeaderViewController*) headerViewController
{
    if (!_headerViewController)
        _headerViewController = [[DKHeaderViewController alloc] init];
    return _headerViewController;
}

@synthesize bodyViewController = _bodyViewController;

- (DKBodyViewController*) bodyViewController
{
    if (!_bodyViewController)
        _bodyViewController = [[DKBodyViewController alloc] init];
    return _bodyViewController;
}

@end
