//
//  Optionals.swift
//  SwiftTest
//
//  Created by Kai Brüning on 1.8.14.
//  Copyright (c) 2014 Hippocampus Software GmbH. All rights reserved.
//

import Foundation

func exerciseOptionals() {
    // Als einzige Ausnahme müssen Optional-Werte nicht explizit initialisiert werden, sondern werden automatisch auf nil gesetzt.
    var optionalString: String?
    
    printOptionalString (optionalString)

    optionalString = "Optional"
    printOptionalString (optionalString)

    // Das Ausrufezeichen hinter einem Optional-Wert packt den enthaltenen Wert aus.
    println("optionalString ausgepackt: \(optionalString!)")
    
    optionalString = nil
    // Ohne den Test "if (optionalString)" würde die nächste Zeile das Programm beenden mit "fatal error: unexpectedly found nil while unwrapping an Optional value"
    if (optionalString != nil) {
        println("optionalString ausgepackt: \(optionalString!)")
    }

    // Implizit ausgepackte Optionals können wie ihr Basistyp verwendet werden, der Compiler macht das Auspacken automatisch. Aber wehe, der Wert ist nil!
    var implicitlyUnwrappedOptional: String! = "Implicitly Unwrapped Optional"
    println("Hash von implicitlyUnwrappedOptional: \(implicitlyUnwrappedOptional.hash)")
    
    implicitlyUnwrappedOptional = nil;
    // Ähnlich wie oben: ohne den Test gibt’s einen Absturz.
    if (implicitlyUnwrappedOptional != nil) {
        println("Hash von implicitlyUnwrappedOptional: \(implicitlyUnwrappedOptional.hash)")
    }
}

func printOptionalString(param:String?) {
    // Der "if let" Konstrukt kombiniert Test auf nil mit dem Auspacken des Optionals.
    if let s = param {
        println("param ist: \(s)")
    } else {
        println("param ist nil")
    }
}