//
//  PersonTests.swift
//  SwiftTest
//
//  Created by Kai Brüning on 30/07/14.
//  Copyright (c) 2014 Hippocampus Software GmbH. All rights reserved.
//

import Foundation

func exercisePersonWithName() {
    
    let manager = PersonManager.sharedInstance
    
    var newName = "Karl"

    let person1 = Person(name:newName)
    
    newName += "-Heinz"
    let person2 = Person(name:newName)
    
    // Der Name von person1 ist immer noch "Karl".
    assert (person1.name == "Karl")
    
    if let person = manager.personWithName("Karl") {
        println ("Gefunden: \(person.name)")
    } else {
        println ("Karl nicht gefunden")
    }
    
    if let person = manager.personWithName("Karl-Heinz") {
        println ("Gefunden: \(person.name)")
    } else {
        println ("Karl-Heinz nicht gefunden")
    }

    if let person = manager.personWithName("Otto") {
        println ("Gefunden: \(person.name)")
    } else {
        println ("Otto nicht gefunden")
    }
    
    person2.name = "Otto"
    if let person = manager.personWithName("Otto") {
        println ("Gefunden: \(person.name)")
    } else {
        println ("Otto nicht gefunden")
    }
    
    if let person = manager.personWithName("Karl-Heinz") {
        println ("Gefunden: \(person.name)")
    } else {
        println ("Karl-Heinz nicht gefunden")
    }
}


func exercisePersonWithNameAndBirthDay() {
    let dateFormatter = NSDateFormatter()
    dateFormatter.dateFormat = "d.M.yyyy"
    dateFormatter.timeZone = NSTimeZone(forSecondsFromGMT:0)

    var date: AnyObject?
    var error: NSError?
    let success = dateFormatter.getObjectValue(&date, forString:"24.12.1955", range: nil, error: &error)
    if (success) {
        println ("\(date)")
    }

    let date1 = dateFormatter.dateFromString("24.12.1955")
    println ("\(date1)")

    let karl_1 = Person(name:"Karl")
    karl_1.birthday = dateFormatter.dateFromString("24.12.1955")

    let karl_2 = Person(name:"Karl")
    karl_2.birthday = dateFormatter.dateFromString("1.1.1999")

    let otto = Person(name:"Otto")
    otto.birthday = dateFormatter.dateFromString("29.8.1958")
    
    let manager = PersonManager.sharedInstance
    
    if let person = manager.personWithName("Karl", birthday: dateFormatter.dateFromString("1.1.1999")!) {
        println ("\(person.name) hat am \(dateFormatter.stringFromDate(person.birthday!)) Geburtstag")
    } else {
        println ("nicht gefunden")
    }
    
    if let person = manager.personWithName("Karl", birthday: dateFormatter.dateFromString("2.1.1999")!) {
        println ("\(person.name) hat am \(dateFormatter.stringFromDate(person.birthday!)) Geburtstag")
    } else {
        println ("nicht gefunden")
    }

    if let person = manager.personWithName("Karl", birthday: dateFormatter.dateFromString("24.12.1955")!) {
        println ("\(person.name) hat am \(dateFormatter.stringFromDate(person.birthday!)) Geburtstag")
    } else {
        println ("nicht gefunden")
    }

    // Änderen des Geburtstages bringt die Nachschlagtabelle automatisch auf den neusten Stand.
    karl_2.birthday = dateFormatter.dateFromString("2.1.1999")

    if let person = manager.personWithName("Karl", birthday: dateFormatter.dateFromString("1.1.1999")!) {
        println ("\(person.name) hat am \(dateFormatter.stringFromDate(person.birthday!)) Geburtstag")
    } else {
        println ("nicht gefunden")
    }
    
    if let person = manager.personWithName("Karl", birthday: dateFormatter.dateFromString("2.1.1999")!) {
        println ("\(person.name) hat am \(dateFormatter.stringFromDate(person.birthday!)) Geburtstag")
    } else {
        println ("nicht gefunden")
    }
}
