//
//  ResultExample.swift
//  SwiftTest
//
//  Created by Kai Brüning on 24.7.14.
//  Copyright (c) 2014 Hippocampus Software GmbH. All rights reserved.
//

import Foundation

// ACHTUNG: In der Beta 6 kann der Result<T> nicht übersetzen und meldet "unimplemented IR generation feature non-fixed multi-payload enum layout". Diese Datei ist daher nicht Teil des Targets.

func failable (text: String, #succeed: Bool) -> Result<String> {
    if (succeed) {
        return Result<String> (text)
    } else {
        let error = NSError (domain: "SwiftTest", code: 1, userInfo: nil)
        return Result<String> (error)
    }
}

func testResult() {
    
    let r1 = failable("Test 1", succeed:true)
    if (r1 != nil) {
        println("Succeeded with \(r1.value)")
    } else {
        println("Failed with \(r1.error?.description)")
    }

    let r2 = failable("Test 2", succeed:false)
    if (r2.isSuccess) {
        println("Succeeded with \(r2.value)")
    } else {
        println("Failed with \(r2.error?.description)")
    }
}