//
//  TodayViewController.m
//  Top-5-Extension
//
//  Created by Markus Stöbe on 30.08.14.
//
//

#import "TodayViewController.h"
#import <NotificationCenter/NotificationCenter.h>
#import "Song.h"

@interface TodayViewController () <NCWidgetProviding>
@property (strong, nonatomic) NSFetchedResultsController *fetchedResultsController;
@end

@implementation TodayViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.preferredContentSize = CGSizeMake(250.0, 5*44.0);
    self.tableView.backgroundColor = [UIColor clearColor];
}

- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:animated];
    [self.tableView reloadData];
}

- (void)widgetPerformUpdateWithCompletionHandler:(void (^)(NCUpdateResult))completionHandler {
    completionHandler(NCUpdateResultNewData);
}

#pragma mark - Table View
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return [[self.fetchedResultsController sections] count];
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    id <NSFetchedResultsSectionInfo> sectionInfo = [self.fetchedResultsController sections][section];
    return [sectionInfo numberOfObjects];
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"Cell" forIndexPath:indexPath];
    Song *song            = [self.fetchedResultsController objectAtIndexPath:indexPath];
    cell.textLabel.text      = [NSString stringWithFormat:NSLocalizedString(@"#%d %@", @"#%d %@"), [song.rank integerValue], song.title];
    cell.backgroundColor     = [UIColor clearColor];
   return cell;
}

#pragma mark - fetchedResultsController
- (NSFetchedResultsController *)fetchedResultsController {
    
    if (_fetchedResultsController == nil) {
        NSFetchRequest *fetchRequest = [[NSFetchRequest alloc] init];
        [fetchRequest setEntity:[NSEntityDescription entityForName:@"Song" inManagedObjectContext:[CDHandler sharedController].managedObjectContext]];

        // Set the batch size to a suitable number.
        [fetchRequest setFetchLimit:5];

        NSArray *sortDescriptors = @[[[NSSortDescriptor alloc] initWithKey:@"rank" ascending:YES]];
        [fetchRequest setSortDescriptors:sortDescriptors];
        _fetchedResultsController = [[NSFetchedResultsController alloc] initWithFetchRequest:fetchRequest
                                                                        managedObjectContext:[CDHandler sharedController].managedObjectContext
                                                                          sectionNameKeyPath:nil
                                                                                   cacheName:nil];
        NSError *error = nil;
        if (![self.fetchedResultsController performFetch:&error]) {
            // Replace this implementation with code to handle the error appropriately.
            // abort() causes the application to generate a crash log and terminate. You should not use this function in a shipping application, although it may be useful during development.
            NSLog(@"Unresolved error %@, %@", error, [error userInfo]);
            abort();
        }
    }
    return _fetchedResultsController;
}

@end
