//
//  Shaders.metal
//  Example-1
//
//  Created by Boris Bügling on 14/12/14.
//  Copyright (c) 2014 Boris Bügling. All rights reserved.
//

#include <metal_stdlib>

using namespace metal;

struct VertexIn{
    packed_float3 position;
    packed_float2 texCoord; // Texturkoordinaten Input
};

struct VertexOut{
    float4 position [[position]];
    float2 texCoord [[user(texturecoord)]];; // Texturkoordinaten Output
};

struct Uniforms{
    float4x4 modelMatrix;
    float4x4 projectionMatrix;
};

vertex VertexOut lighting_vertex(const device VertexIn* vertex_array [[ buffer(0) ]],
                                 const device Uniforms&  uniforms    [[ buffer(1) ]],
                                 unsigned int vid [[ vertex_id ]]) {

    float4x4 mv_Matrix = uniforms.modelMatrix;
    float4x4 proj_Matrix = uniforms.projectionMatrix;

    VertexIn VertexIn = vertex_array[vid];

    VertexOut VertexOut;
    VertexOut.position = proj_Matrix * mv_Matrix * float4(VertexIn.position, 1);
    // Texturkoordinaten werden direkt übernommen
    VertexOut.texCoord = vertex_array[vid].texCoord;

    return VertexOut;
}

/*fragment half4 lighting_fragment() {
    return half4(1.0);
}*/

fragment float4 lighting_fragment(VertexOut interpolated [[stage_in]],
                                  texture2d<float>  tex2D     [[ texture(0) ]],
                                  sampler           sampler2D [[ sampler(0) ]]) {
    // Anstatt einer Farbe werden die Pixeldaten der Textur zurückgegeben
    return tex2D.sample(sampler2D, interpolated.texCoord);
}
