//
//  fractal_cpu.c
//  Gaston
//
//  Created by Richard Kurz on 16.01.14.
//  Copyright (c) 2014 Richard Kurz (Public Domain). No rights reserved.
//

#include <stdio.h>
#include <math.h>


// Im realen Leben sollte hier nicht per Pixel, sondern zumindest zeilenweise gerechnet werden.
// Das erspart den Overhead des Aufrufs und der Parameterübergabe.

void fractal_scalar(size_t index, int maxDepth, int pixWidth, int pixHeight,
                    float left, float top, float width, float height, float a, float b,
                    float* output)
{
  float x = left + width * ((float)(index % pixWidth) / pixWidth);
  float y = top + height * ((float)(index / pixWidth) / pixHeight);
  float x2, y2;
  int depth = 0;
  
  do
  {
    y2 = y * y;
    x2 = x * x;
    if (y2 + x2 > 4.f) break;
    y = x * y * 2.f + b;
    x = x2 - y2 + a;
  }
  while (depth++ < maxDepth);

  output[index] = (float)depth - logf(logf(x2 + y2) * 0.5f) / M_LN2;
  
  // Wegen log(r2) wird depth NaN, wenn (depth >= maxDepth). Alternative:
  // if (depth >= maxDepth) output[index] = maxDepth;
  // else output[index] = (float)depth - logf(logf(x2 + y2) * 0.5f) / M_LN2;
}


void colorit_scalar(size_t index, int maxDepth, float* input, int* output)
{
  float depth = input[index];

  unsigned char r = depth / maxDepth * 255.f;
  unsigned char g = (cosf(depth * 0.10) + 1.f) * 127.f;
  unsigned char b = (sinf(depth * 0.01) + 1.f) * 127.f;

  output[index] = 255 << 24 | b << 16 | g << 8 | r;
}


