//
//  ViewController.swift
//  HeiseNotifications
//
//  Created by Gero Gerber on 12/11/2016.
//  Copyright © 2016 Gero Gerber. All rights reserved.
//

import UIKit
import UserNotifications

class ViewController: UIViewController, UNUserNotificationCenterDelegate
{
    override func viewDidLoad()
    {
        super.viewDidLoad()
        
        initializeNotifications()
    }

    @IBAction func inAppNotificationTouchUpInside(_ sender: Any) {
        let content = UNMutableNotificationContent()
        content.title = "Notifications"
        content.subtitle = "Was ist neu?"
        content.body = "Was man alles mit Notifications machen kann..."
        content.badge = 1;
        content.categoryIdentifier = "categoryLocal"
        
        let trigger = UNTimeIntervalNotificationTrigger(timeInterval: 5, repeats: false)
        let requestIdentifier = "meinRequest"
        
        let request = UNNotificationRequest(identifier: requestIdentifier, content: content, trigger: trigger)
        
        UNUserNotificationCenter.current().add(request) {
            (error) in
            print(error ?? "Ok")
        }
    }
    
    @IBAction func nonInAppNotificationTouchUpInside(_ sender: Any) {
        let content = UNMutableNotificationContent()
        content.title = "Notifications"
        content.subtitle = "Was ist neu?"
        content.body = "Was man alles mit Notifications machen kann..."
        content.badge = 1;
        
        let trigger = UNTimeIntervalNotificationTrigger(timeInterval: 5, repeats: false)
        let requestIdentifier = "sampleRequestNonInApp"
        
        let request = UNNotificationRequest(identifier: requestIdentifier, content: content, trigger: trigger)
        
        UNUserNotificationCenter.current().add(request, withCompletionHandler: {
            (error) in
            print("Added Notification Request - Error: \(error)")
        })
    }
    
    @IBAction func removeNotificationTouchUpInside(_ sender: Any) {
        UNUserNotificationCenter.current().removePendingNotificationRequests(withIdentifiers: ["meinRequest"])
    }
    
    @IBAction func updateNotificationTouchUpInside(_ sender: Any) {
        let content = UNMutableNotificationContent()
        content.title = "Notifications (updated)"
        content.subtitle = "Was ist neu? (updated)"
        content.body = "Was man alles mit Notifications machen kann... (updated)"
        content.badge = 1;
        
        let trigger = UNTimeIntervalNotificationTrigger(timeInterval: 5, repeats: false)
        let requestIdentifier = "meinRequest"
        
        let request = UNNotificationRequest(identifier: requestIdentifier, content: content, trigger: trigger)
        
        UNUserNotificationCenter.current().add(request) {
            (error) in
        }
    }
    
    @IBAction func resetBadgeCountTouchUpInside(_ sender: Any) {
        UIApplication.shared.applicationIconBadgeNumber = 0
    }
    
    func initializeNotifications() {
        let notificationCenter = UNUserNotificationCenter.current()
        notificationCenter.delegate = self
        
        UNUserNotificationCenter.current().requestAuthorization(options: [.alert, .badge, .sound]) {
            (granted, error) in
            if granted == false
            {
                print("Failed to authorize: \(error)")
            }
        }
        
        UNUserNotificationCenter.current().getNotificationSettings() {
            (settings) in
            print("Alerts: \(ViewController.notificationSettingToString(setting: settings.alertSetting))")
            print("Badge: \(ViewController.notificationSettingToString(setting: settings.badgeSetting))")
            print("Sounds: \(ViewController.notificationSettingToString(setting: settings.soundSetting))")
            print("Style: \(ViewController.alertStyleSettingToString(setting: settings.alertStyle))")
        }
        
        UIApplication.shared.registerForRemoteNotifications()
        
        // Register Actions + Category for Local Notifications
        let openWebsiteAction = UNNotificationAction(identifier: "openWebsite", title: "Website öffnen", options: [.foreground])
        let categoryLocal = UNNotificationCategory(identifier: "categoryLocal", actions: [openWebsiteAction], intentIdentifiers: [], options: [])
        
        // Register Actions + Category for Remote Notifications
        let likeAction = UNNotificationAction(identifier: "likeAction", title: "Gefällt mir", options: [])
        let textInputAction = UNTextInputNotificationAction(identifier: "textInputAction", title: "Text-Eingabe", options: [], textInputButtonTitle: "Done", textInputPlaceholder: "Dummy Input")
        let dismissAction = UNNotificationAction(identifier: "dismissAction", title: "Schliessen", options: [])
        let categoryRemote = UNNotificationCategory(identifier: "categoryRemote", actions: [likeAction, textInputAction, dismissAction], intentIdentifiers: [], options: [UNNotificationCategoryOptions.customDismissAction])
        
        UNUserNotificationCenter.current().setNotificationCategories([categoryLocal, categoryRemote])
    }
    
    func userNotificationCenter(_ center: UNUserNotificationCenter, willPresent notification: UNNotification, withCompletionHandler completionHandler: @escaping (UNNotificationPresentationOptions) -> Void) {
        
        // Here we decide if we want to show the notification while our app is in foreground
        if notification.request.identifier == "meinRequest"
        {
            completionHandler([.alert, .badge, .sound])
        }
    }
    
    func userNotificationCenter(_ center: UNUserNotificationCenter, didReceive response: UNNotificationResponse, withCompletionHandler completionHandler: @escaping () -> Void) {
        if response.actionIdentifier == "openWebsite"
        {
            UIApplication.shared.open(URL(string: "https://www.heise.de/mac-and-i/")!, options: [:], completionHandler: nil)
        }
        
        completionHandler()
    }
    
    static func notificationSettingToString(setting: UNNotificationSetting) -> String {
        switch(setting)
        {
        case .disabled: return "Disabled"
        case .enabled: return "Enabled"
        case .notSupported: return "Not Supported"
        }
    }
    
    static func alertStyleSettingToString(setting: UNAlertStyle) -> String {
        switch(setting)
        {
        case .none: return "None"
        case .banner: return "Banner"
        case .alert: return "Alert"
        }
    }
}

