//: Playground - noun: a place where people can play

import UIKit

// Breite und Höhe des darzustellenden View-Objekts
let w=500, h=300

// von UIView abgeleitete Klasse mit eigener 
// draw-Methode
class MyView: UIView {
  override func draw(_ rect: CGRect) {
    let start = CGPoint(x: 10, y: 20)   // links oben
    let end   = CGPoint(x: w-10, y: h-10) // rechts unten
    
    let line = UIBezierPath()
    line.move(to: start)     // Startpunkt festlegen
    line.addLine(to: end)    // Linie zum Endpunkt
    line.lineWidth = 3       // Linienbreite
    UIColor.red.setStroke()  // Farbe einstellen
    line.stroke()            // Linie zeichnen
  }
}

// normale UIView als Container
let container = UIView(frame: CGRect(x: 0, y: 0, width: w, height: h))

// eigene View mit Grafik
let view = MyView()
view.backgroundColor =   // hellgrau
  UIColor(colorLiteralRed: 0.9, green: 0.9, blue: 0.9, alpha: 1)
view.frame = container.frame

// View in den Container einfügen
container.addSubview(view)

